// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class GeoValidationMethodConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCoerce = System.Text.Json.JsonEncodedText.Encode("coerce");
	private static readonly System.Text.Json.JsonEncodedText MemberIgnoreMalformed = System.Text.Json.JsonEncodedText.Encode("ignore_malformed");
	private static readonly System.Text.Json.JsonEncodedText MemberStrict = System.Text.Json.JsonEncodedText.Encode("strict");

	public override Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCoerce))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Coerce;
		}

		if (reader.ValueTextEquals(MemberIgnoreMalformed))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.IgnoreMalformed;
		}

		if (reader.ValueTextEquals(MemberStrict))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Strict;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCoerce.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Coerce;
		}

		if (string.Equals(value, MemberIgnoreMalformed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.IgnoreMalformed;
		}

		if (string.Equals(value, MemberStrict.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Strict;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Coerce:
				writer.WriteStringValue(MemberCoerce);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.IgnoreMalformed:
				writer.WriteStringValue(MemberIgnoreMalformed);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod.Strict:
				writer.WriteStringValue(MemberStrict);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}