// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.GeoShapeQueryConverter))]
public sealed partial class GeoShapeQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoShapeQuery(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQuery shape)
	{
		Field = field;
		Shape = shape;
	}
#if NET7_0_OR_GREATER
	public GeoShapeQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoShapeQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoShapeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public bool? IgnoreUnmapped { get; set; }
	public string? QueryName { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQuery Shape { get; set; }
}

public readonly partial struct GeoShapeQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoShapeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoShapeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Shape(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQuery value)
	{
		Instance.Shape = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Shape()
	{
		Instance.Shape = Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument> Shape(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor<TDocument>>? action)
	{
		Instance.Shape = Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoShapeQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoShapeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoShapeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Shape(Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQuery value)
	{
		Instance.Shape = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Shape()
	{
		Instance.Shape = Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Shape(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor>? action)
	{
		Instance.Shape = Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor Shape<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor<T>>? action)
	{
		Instance.Shape = Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeFieldQueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.GeoShapeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}