// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.GeoPolygonQueryConverter))]
public sealed partial class GeoPolygonQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoPolygonQuery(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPoints polygon)
	{
		Field = field;
		Polygon = polygon;
	}
#if NET7_0_OR_GREATER
	public GeoPolygonQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoPolygonQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoPolygonQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
	public bool? IgnoreUnmapped { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPoints Polygon { get; set; }
	public string? QueryName { get; set; }
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? ValidationMethod { get; set; }
}

public readonly partial struct GeoPolygonQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoPolygonQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoPolygonQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> Polygon(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPoints value)
	{
		Instance.Polygon = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> Polygon(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPointsDescriptor> action)
	{
		Instance.Polygon = Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPointsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument> ValidationMethod(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? value)
	{
		Instance.ValidationMethod = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoPolygonQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoPolygonQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoPolygonQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor Polygon(Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPoints value)
	{
		Instance.Polygon = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor Polygon(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPointsDescriptor> action)
	{
		Instance.Polygon = Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonPointsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor ValidationMethod(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? value)
	{
		Instance.ValidationMethod = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.GeoPolygonQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}