// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class GeoExecutionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution>
{
	private static readonly System.Text.Json.JsonEncodedText MemberIndexed = System.Text.Json.JsonEncodedText.Encode("indexed");
	private static readonly System.Text.Json.JsonEncodedText MemberMemory = System.Text.Json.JsonEncodedText.Encode("memory");

	public override Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberIndexed))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Indexed;
		}

		if (reader.ValueTextEquals(MemberMemory))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Memory;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberIndexed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Indexed;
		}

		if (string.Equals(value, MemberMemory.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Memory;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Indexed:
				writer.WriteStringValue(MemberIndexed);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution.Memory:
				writer.WriteStringValue(MemberMemory);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}