// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.GeoBoundingBoxQueryConverter))]
public sealed partial class GeoBoundingBoxQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.GeoBounds boundingBox, Elastic.Clients.Elasticsearch.Field field)
	{
		BoundingBox = boundingBox;
		Field = field;
	}
#if NET7_0_OR_GREATER
	public GeoBoundingBoxQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GeoBoundingBoxQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.GeoBounds BoundingBox { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public bool? IgnoreUnmapped { get; set; }
	public string? QueryName { get; set; }
	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution? Type { get; set; }

	/// <summary>
	/// <para>
	/// Set to <c>IGNORE_MALFORMED</c> to accept geo points with invalid latitude or longitude.
	/// Set to <c>COERCE</c> to also try to infer correct latitude or longitude.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? ValidationMethod { get; set; }
}

public readonly partial struct GeoBoundingBoxQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoBoundingBoxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoBoundingBoxQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> BoundingBox(Elastic.Clients.Elasticsearch.GeoBounds value)
	{
		Instance.BoundingBox = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> BoundingBox(System.Func<Elastic.Clients.Elasticsearch.GeoBoundsFactory, Elastic.Clients.Elasticsearch.GeoBounds> action)
	{
		Instance.BoundingBox = Elastic.Clients.Elasticsearch.GeoBoundsFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> Type(Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution? value)
	{
		Instance.Type = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>IGNORE_MALFORMED</c> to accept geo points with invalid latitude or longitude.
	/// Set to <c>COERCE</c> to also try to infer correct latitude or longitude.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument> ValidationMethod(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? value)
	{
		Instance.ValidationMethod = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct GeoBoundingBoxQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoBoundingBoxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GeoBoundingBoxQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor BoundingBox(Elastic.Clients.Elasticsearch.GeoBounds value)
	{
		Instance.BoundingBox = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor BoundingBox(System.Func<Elastic.Clients.Elasticsearch.GeoBoundsFactory, Elastic.Clients.Elasticsearch.GeoBounds> action)
	{
		Instance.BoundingBox = Elastic.Clients.Elasticsearch.GeoBoundsFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>true</c> to ignore an unmapped field and not match any documents for this query.
	/// Set to <c>false</c> to throw an exception if the field is not mapped.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor IgnoreUnmapped(bool? value = true)
	{
		Instance.IgnoreUnmapped = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Obsolete("Deprecated in '7.14.0'.")]
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor Type(Elastic.Clients.Elasticsearch.QueryDsl.GeoExecution? value)
	{
		Instance.Type = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Set to <c>IGNORE_MALFORMED</c> to accept geo points with invalid latitude or longitude.
	/// Set to <c>COERCE</c> to also try to infer correct latitude or longitude.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor ValidationMethod(Elastic.Clients.Elasticsearch.QueryDsl.GeoValidationMethod? value)
	{
		Instance.ValidationMethod = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.GeoBoundingBoxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}