// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.FuzzyQueryConverter))]
public sealed partial class FuzzyQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FuzzyQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FuzzyQuery(Elastic.Clients.Elasticsearch.Field field, object value)
	{
		Field = field;
		Value = value;
	}
#if NET7_0_OR_GREATER
	public FuzzyQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FuzzyQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fuzziness? Fuzziness { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of variations created.
	/// </para>
	/// </summary>
	public int? MaxExpansions { get; set; }

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public int? PrefixLength { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public string? Rewrite { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether edits include transpositions of two adjacent characters (for example <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public bool? Transpositions { get; set; }

	/// <summary>
	/// <para>
	/// Term you wish to find in the provided field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	object Value { get; set; }
}

public readonly partial struct FuzzyQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FuzzyQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FuzzyQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of variations created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> MaxExpansions(int? value)
	{
		Instance.MaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> PrefixLength(int? value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether edits include transpositions of two adjacent characters (for example <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Transpositions(bool? value = true)
	{
		Instance.Transpositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Term you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument> Value(object value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FuzzyQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FuzzyQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FuzzyQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum edit distance allowed for matching.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of variations created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor MaxExpansions(int? value)
	{
		Instance.MaxExpansions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor PrefixLength(int? value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of beginning characters left unchanged when creating expansions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Rewrite(string? value)
	{
		Instance.Rewrite = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether edits include transpositions of two adjacent characters (for example <c>ab</c> to <c>ba</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Transpositions(bool? value = true)
	{
		Instance.Transpositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Term you wish to find in the provided field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor Value(object value)
	{
		Instance.Value = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.FuzzyQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}