// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.FunctionScoreQueryConverter))]
public sealed partial class FunctionScoreQuery
{
#if NET7_0_OR_GREATER
	public FunctionScoreQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FunctionScoreQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Defines how he newly computed score is combined with the score of the query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionBoostMode? BoostMode { get; set; }

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>? Functions { get; set; }

	/// <summary>
	/// <para>
	/// Restricts the new score to not exceed the provided limit.
	/// </para>
	/// </summary>
	public double? MaxBoost { get; set; }

	/// <summary>
	/// <para>
	/// Excludes documents that do not meet the provided score threshold.
	/// </para>
	/// </summary>
	public double? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Specifies how the computed scores are combined
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode? ScoreMode { get; set; }
}

public readonly partial struct FunctionScoreQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FunctionScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FunctionScoreQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how he newly computed score is combined with the score of the query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> BoostMode(Elastic.Clients.Elasticsearch.QueryDsl.FunctionBoostMode? value)
	{
		Instance.BoostMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Functions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>? value)
	{
		Instance.Functions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Functions(params Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore[] values)
	{
		Instance.Functions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Functions(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor<TDocument>.Build(action));
		}

		Instance.Functions = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restricts the new score to not exceed the provided limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> MaxBoost(double? value)
	{
		Instance.MaxBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Excludes documents that do not meet the provided score threshold.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how the computed scores are combined
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument> ScoreMode(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode? value)
	{
		Instance.ScoreMode = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FunctionScoreQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FunctionScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FunctionScoreQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines how he newly computed score is combined with the score of the query
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor BoostMode(Elastic.Clients.Elasticsearch.QueryDsl.FunctionBoostMode? value)
	{
		Instance.BoostMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Functions(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>? value)
	{
		Instance.Functions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Functions(params Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore[] values)
	{
		Instance.Functions = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Functions(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor.Build(action));
		}

		Instance.Functions = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more functions that compute a new score for each document returned by the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Functions<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreDescriptor<T>.Build(action));
		}

		Instance.Functions = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Restricts the new score to not exceed the provided limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor MaxBoost(double? value)
	{
		Instance.MaxBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Excludes documents that do not meet the provided score threshold.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A query that determines the documents for which a new score is computed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how the computed scores are combined
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor ScoreMode(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode? value)
	{
		Instance.ScoreMode = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}