// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class FunctionScoreModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText MemberFirst = System.Text.Json.JsonEncodedText.Encode("first");
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberMultiply = System.Text.Json.JsonEncodedText.Encode("multiply");
	private static readonly System.Text.Json.JsonEncodedText MemberSum = System.Text.Json.JsonEncodedText.Encode("sum");

	public override Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAvg))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Avg;
		}

		if (reader.ValueTextEquals(MemberFirst))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.First;
		}

		if (reader.ValueTextEquals(MemberMax))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Max;
		}

		if (reader.ValueTextEquals(MemberMin))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Min;
		}

		if (reader.ValueTextEquals(MemberMultiply))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Multiply;
		}

		if (reader.ValueTextEquals(MemberSum))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Sum;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAvg.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Avg;
		}

		if (string.Equals(value, MemberFirst.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.First;
		}

		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Max;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Min;
		}

		if (string.Equals(value, MemberMultiply.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Multiply;
		}

		if (string.Equals(value, MemberSum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Sum;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Avg:
				writer.WriteStringValue(MemberAvg);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.First:
				writer.WriteStringValue(MemberFirst);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Min:
				writer.WriteStringValue(MemberMin);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Multiply:
				writer.WriteStringValue(MemberMultiply);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode.Sum:
				writer.WriteStringValue(MemberSum);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.FunctionScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}