// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class FunctionScoreConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore>
{
	private static readonly System.Text.Json.JsonEncodedText PropFilter = System.Text.Json.JsonEncodedText.Encode("filter");
	private static readonly System.Text.Json.JsonEncodedText PropWeight = System.Text.Json.JsonEncodedText.Encode("weight");
	private static readonly System.Text.Json.JsonEncodedText VariantExp = System.Text.Json.JsonEncodedText.Encode("exp");
	private static readonly System.Text.Json.JsonEncodedText VariantFieldValueFactor = System.Text.Json.JsonEncodedText.Encode("field_value_factor");
	private static readonly System.Text.Json.JsonEncodedText VariantGauss = System.Text.Json.JsonEncodedText.Encode("gauss");
	private static readonly System.Text.Json.JsonEncodedText VariantLinear = System.Text.Json.JsonEncodedText.Encode("linear");
	private static readonly System.Text.Json.JsonEncodedText VariantRandomScore = System.Text.Json.JsonEncodedText.Encode("random_score");
	private static readonly System.Text.Json.JsonEncodedText VariantScriptScore = System.Text.Json.JsonEncodedText.Encode("script_score");

	public override Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.QueryDsl.Query?> propFilter = default;
		LocalJsonValue<double?> propWeight = default;
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFilter.TryReadProperty(ref reader, options, PropFilter, null))
			{
				continue;
			}

			if (propWeight.TryReadProperty(ref reader, options, PropWeight, static double? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<double>(o)))
			{
				continue;
			}

			if (reader.ValueTextEquals(VariantExp))
			{
				variantType = VariantExp.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantFieldValueFactor))
			{
				variantType = VariantFieldValueFactor.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorScoreFunction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantGauss))
			{
				variantType = VariantGauss.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantLinear))
			{
				variantType = VariantLinear.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRandomScore))
			{
				variantType = VariantRandomScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.RandomScoreFunction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantScriptScore))
			{
				variantType = VariantScriptScore.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.QueryDsl.ScriptScoreFunction>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant,
			Filter = propFilter.Value,
			Weight = propWeight.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "exp":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction)value.Variant, null, null);
				break;
			case "field_value_factor":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorScoreFunction)value.Variant, null, null);
				break;
			case "gauss":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction)value.Variant, null, null);
				break;
			case "linear":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction)value.Variant, null, null);
				break;
			case "random_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.RandomScoreFunction)value.Variant, null, null);
				break;
			case "script_score":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.QueryDsl.ScriptScoreFunction)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.FunctionScore)}'.");
		}

		writer.WriteProperty(options, PropFilter, value.Filter, null, null);
		writer.WriteProperty(options, PropWeight, value.Weight, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, double? v) => w.WriteNullableValue<double>(o, v));
		writer.WriteEndObject();
	}
}