// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.FieldValueFactorModifierConverter))]
public enum FieldValueFactorModifier
{
	/// <summary>
	/// <para>
	/// Take the natural logarithm of the field value.
	/// Because this function will return a negative value and cause an error if used on values between 0 and 1, it is recommended to use <c>ln1p</c> instead.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "ln")]
	Ln,
	/// <summary>
	/// <para>
	/// Add 1 to the field value and take the natural logarithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "ln1p")]
	Ln1p,
	/// <summary>
	/// <para>
	/// Add 2 to the field value and take the natural logarithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "ln2p")]
	Ln2p,
	/// <summary>
	/// <para>
	/// Take the common logarithm of the field value.
	/// Because this function will return a negative value and cause an error if used on values between 0 and 1, it is recommended to use <c>log1p</c> instead.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "log")]
	Log,
	/// <summary>
	/// <para>
	/// Add 1 to the field value and take the common logarithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "log1p")]
	Log1p,
	/// <summary>
	/// <para>
	/// Add 2 to the field value and take the common logarithm.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "log2p")]
	Log2p,
	/// <summary>
	/// <para>
	/// Do not apply any multiplier to the field value.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "none")]
	None,
	/// <summary>
	/// <para>
	/// Reciprocate the field value, same as <c>1/x</c> where <c>x</c> is the field’s value.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "reciprocal")]
	Reciprocal,
	/// <summary>
	/// <para>
	/// Take the square root of the field value.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "sqrt")]
	Sqrt,
	/// <summary>
	/// <para>
	/// Square the field value (multiply it by itself).
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "square")]
	Square
}