// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class FieldValueFactorModifierConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLn = System.Text.Json.JsonEncodedText.Encode("ln");
	private static readonly System.Text.Json.JsonEncodedText MemberLn1p = System.Text.Json.JsonEncodedText.Encode("ln1p");
	private static readonly System.Text.Json.JsonEncodedText MemberLn2p = System.Text.Json.JsonEncodedText.Encode("ln2p");
	private static readonly System.Text.Json.JsonEncodedText MemberLog = System.Text.Json.JsonEncodedText.Encode("log");
	private static readonly System.Text.Json.JsonEncodedText MemberLog1p = System.Text.Json.JsonEncodedText.Encode("log1p");
	private static readonly System.Text.Json.JsonEncodedText MemberLog2p = System.Text.Json.JsonEncodedText.Encode("log2p");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");
	private static readonly System.Text.Json.JsonEncodedText MemberReciprocal = System.Text.Json.JsonEncodedText.Encode("reciprocal");
	private static readonly System.Text.Json.JsonEncodedText MemberSqrt = System.Text.Json.JsonEncodedText.Encode("sqrt");
	private static readonly System.Text.Json.JsonEncodedText MemberSquare = System.Text.Json.JsonEncodedText.Encode("square");

	public override Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLn))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln;
		}

		if (reader.ValueTextEquals(MemberLn1p))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln1p;
		}

		if (reader.ValueTextEquals(MemberLn2p))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln2p;
		}

		if (reader.ValueTextEquals(MemberLog))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log;
		}

		if (reader.ValueTextEquals(MemberLog1p))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log1p;
		}

		if (reader.ValueTextEquals(MemberLog2p))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log2p;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.None;
		}

		if (reader.ValueTextEquals(MemberReciprocal))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Reciprocal;
		}

		if (reader.ValueTextEquals(MemberSqrt))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Sqrt;
		}

		if (reader.ValueTextEquals(MemberSquare))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Square;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLn.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln;
		}

		if (string.Equals(value, MemberLn1p.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln1p;
		}

		if (string.Equals(value, MemberLn2p.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln2p;
		}

		if (string.Equals(value, MemberLog.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log;
		}

		if (string.Equals(value, MemberLog1p.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log1p;
		}

		if (string.Equals(value, MemberLog2p.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log2p;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.None;
		}

		if (string.Equals(value, MemberReciprocal.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Reciprocal;
		}

		if (string.Equals(value, MemberSqrt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Sqrt;
		}

		if (string.Equals(value, MemberSquare.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Square;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln:
				writer.WriteStringValue(MemberLn);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln1p:
				writer.WriteStringValue(MemberLn1p);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Ln2p:
				writer.WriteStringValue(MemberLn2p);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log:
				writer.WriteStringValue(MemberLog);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log1p:
				writer.WriteStringValue(MemberLog1p);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Log2p:
				writer.WriteStringValue(MemberLog2p);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Reciprocal:
				writer.WriteStringValue(MemberReciprocal);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Sqrt:
				writer.WriteStringValue(MemberSqrt);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier.Square:
				writer.WriteStringValue(MemberSquare);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.FieldValueFactorModifier value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}