// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.FieldLookupConverter))]
public sealed partial class FieldLookup
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldLookup(Elastic.Clients.Elasticsearch.Id id)
	{
		Id = id;
	}
#if NET7_0_OR_GREATER
	public FieldLookup()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldLookup()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// <c>id</c> of the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get; set; }

	/// <summary>
	/// <para>
	/// Index from which to retrieve the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// Name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Path { get; set; }

	/// <summary>
	/// <para>
	/// Custom routing value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }
}

public readonly partial struct FieldLookupDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldLookupDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldLookupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// <c>id</c> of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Index from which to retrieve the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> Path(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> Path(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom routing value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FieldLookupDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldLookupDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldLookupDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// <c>id</c> of the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Index from which to retrieve the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor Path(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor Path<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Path = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Custom routing value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookupDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.FieldLookup(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}