// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

/// <summary>
/// <para>
/// A reference to a field with formatting instructions on how to return the value
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.FieldAndFormatConverter))]
public sealed partial class FieldAndFormat
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldAndFormat(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public FieldAndFormat()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldAndFormat()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldAndFormat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A wildcard pattern. The request returns values for field names matching this pattern.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// The format in which the values are returned.
	/// </para>
	/// </summary>
	public string? Format { get; set; }
	public bool? IncludeUnmapped { get; set; }
}

/// <summary>
/// <para>
/// A reference to a field with formatting instructions on how to return the value
/// </para>
/// </summary>
public readonly partial struct FieldAndFormatDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldAndFormatDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldAndFormatDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A wildcard pattern. The request returns values for field names matching this pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A wildcard pattern. The request returns values for field names matching this pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The format in which the values are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument> IncludeUnmapped(bool? value = true)
	{
		Instance.IncludeUnmapped = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

/// <summary>
/// <para>
/// A reference to a field with formatting instructions on how to return the value
/// </para>
/// </summary>
public readonly partial struct FieldAndFormatDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldAndFormatDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldAndFormatDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat instance) => new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A wildcard pattern. The request returns values for field names matching this pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A wildcard pattern. The request returns values for field names matching this pattern.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The format in which the values are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor IncludeUnmapped(bool? value = true)
	{
		Instance.IncludeUnmapped = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}