// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.DisMaxQueryConverter))]
public sealed partial class DisMaxQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DisMaxQuery(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query> queries)
	{
		Queries = queries;
	}
#if NET7_0_OR_GREATER
	public DisMaxQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DisMaxQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DisMaxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query> Queries { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses.
	/// </para>
	/// </summary>
	public double? TieBreaker { get; set; }
}

public readonly partial struct DisMaxQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DisMaxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DisMaxQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> Queries(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query> value)
	{
		Instance.Queries = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> Queries(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Queries = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> Queries(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Queries = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument> TieBreaker(double? value)
	{
		Instance.TieBreaker = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DisMaxQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DisMaxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DisMaxQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor Queries(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query> value)
	{
		Instance.Queries = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor Queries(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Queries = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor Queries(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Queries = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more query clauses.
	/// Returned documents must match one or more of these queries.
	/// If a document matches multiple queries, Elasticsearch uses the highest relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor Queries<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Queries = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor TieBreaker(double? value)
	{
		Instance.TieBreaker = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DisMaxQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}