// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.DecayPlacementConverterFactory))]
public sealed partial class DecayPlacement<TOrigin, TScale>
{
#if NET7_0_OR_GREATER
	public DecayPlacement()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DecayPlacement()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DecayPlacement(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Defines how documents are scored at the distance given at scale.
	/// </para>
	/// </summary>
	public double? Decay { get; set; }

	/// <summary>
	/// <para>
	/// If defined, the decay function will only compute the decay function for documents with a distance greater than the defined <c>offset</c>.
	/// </para>
	/// </summary>
	public TScale? Offset { get; set; }

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public TOrigin? Origin { get; set; }

	/// <summary>
	/// <para>
	/// Defines the distance from origin + offset at which the computed score will equal <c>decay</c> parameter.
	/// </para>
	/// </summary>
	public TScale? Scale { get; set; }
}

public readonly partial struct DecayPlacementOfDateMathDurationDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfDateMathDurationDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfDateMathDurationDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration>(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how documents are scored at the distance given at scale.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor Decay(double? value)
	{
		Instance.Decay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, the decay function will only compute the decay function for documents with a distance greater than the defined <c>offset</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor Offset(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor Origin(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the distance from origin + offset at which the computed score will equal <c>decay</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor Scale(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Scale = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DecayPlacementOfGeoLocationStringDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfGeoLocationStringDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfGeoLocationStringDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string> instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string>(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how documents are scored at the distance given at scale.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Decay(double? value)
	{
		Instance.Decay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, the decay function will only compute the decay function for documents with a distance greater than the defined <c>offset</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Offset(string? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Origin(Elastic.Clients.Elasticsearch.GeoLocation? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Origin()
	{
		Instance.Origin = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Origin(System.Func<Elastic.Clients.Elasticsearch.GeoLocationFactory, Elastic.Clients.Elasticsearch.GeoLocation>? action)
	{
		Instance.Origin = Elastic.Clients.Elasticsearch.GeoLocationFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the distance from origin + offset at which the computed score will equal <c>decay</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor Scale(string? value)
	{
		Instance.Scale = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string> Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfGeoLocationStringDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.GeoLocation, string>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DecayPlacementOfDoubleDoubleDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfDoubleDoubleDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfDoubleDoubleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?>(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how documents are scored at the distance given at scale.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor Decay(double? value)
	{
		Instance.Decay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, the decay function will only compute the decay function for documents with a distance greater than the defined <c>offset</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor Offset(double? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor Origin(double? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the distance from origin + offset at which the computed score will equal <c>decay</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor Scale(double? value)
	{
		Instance.Scale = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?> Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDoubleDoubleDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<double?, double?>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DecayPlacementOfObjectObjectDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object> Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfObjectObjectDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object> instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DecayPlacementOfObjectObjectDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object> instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object>(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Defines how documents are scored at the distance given at scale.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor Decay(double? value)
	{
		Instance.Decay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, the decay function will only compute the decay function for documents with a distance greater than the defined <c>offset</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor Offset(object? value)
	{
		Instance.Offset = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The point of origin used for calculating distance. Must be given as a number for numeric field, date for date fields and geo point for geo fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor Origin(object? value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the distance from origin + offset at which the computed score will equal <c>decay</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor Scale(object? value)
	{
		Instance.Scale = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object> Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfObjectObjectDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<object, object>(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}