// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.DateRangeQueryConverter))]
public sealed partial class DateRangeQuery : Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public DateRangeQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public string? Format { get; set; }

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.DateMath? Gt { get; set; }

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.DateMath? Gte { get; set; }

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.DateMath? Lt { get; set; }

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.DateMath? Lte { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? Relation { get; set; }

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IRangeQuery.Type => "date";
}

public readonly partial struct DateRangeQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Gt(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Gte(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Lt(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Lte(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateRangeQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateRangeQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date format used to convert <c>date</c> values in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Gt(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Gt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Greater than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Gte(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Gte = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Lt(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Lt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Less than or equal to.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Lte(Elastic.Clients.Elasticsearch.DateMath? value)
	{
		Instance.Lte = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates how the range query matches values for <c>range</c> fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor Relation(Elastic.Clients.Elasticsearch.QueryDsl.RangeRelation? value)
	{
		Instance.Relation = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Coordinated Universal Time (UTC) offset or IANA time zone used to convert <c>date</c> values in the query to UTC.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DateRangeQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}