// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.DateDistanceFeatureQueryConverter))]
public sealed partial class DateDistanceFeatureQuery : Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.DateMath origin, Elastic.Clients.Elasticsearch.Duration pivot)
	{
		Field = field;
		Origin = origin;
		Pivot = pivot;
	}
#if NET7_0_OR_GREATER
	public DateDistanceFeatureQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DateDistanceFeatureQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.DateMath Origin { get; set; }

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration Pivot { get; set; }
	public string? QueryName { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IDistanceFeatureQuery.Type => "date";
}

public readonly partial struct DateDistanceFeatureQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDistanceFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> Origin(Elastic.Clients.Elasticsearch.DateMath value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> Pivot(Elastic.Clients.Elasticsearch.Duration value)
	{
		Instance.Pivot = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateDistanceFeatureQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDistanceFeatureQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the field used to calculate distances. This field must meet the following criteria:
	/// be a <c>date</c>, <c>date_nanos</c> or <c>geo_point</c> field;
	/// have an <c>index</c> mapping parameter value of <c>true</c>, which is the default;
	/// have an <c>doc_values</c> mapping parameter value of <c>true</c>, which is the default.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Date or point of origin used to calculate distances.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>origin</c> value must be a date.
	/// Date Math, such as <c>now-1h</c>, is supported.
	/// If the field value is a <c>geo_point</c> field, the <c>origin</c> value must be a geopoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor Origin(Elastic.Clients.Elasticsearch.DateMath value)
	{
		Instance.Origin = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Distance from the <c>origin</c> at which relevance scores receive half of the <c>boost</c> value.
	/// If the <c>field</c> value is a <c>date</c> or <c>date_nanos</c> field, the <c>pivot</c> value must be a time unit, such as <c>1h</c> or <c>10d</c>. If the <c>field</c> value is a <c>geo_point</c> field, the <c>pivot</c> value must be a distance unit, such as <c>1km</c> or <c>12m</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor Pivot(Elastic.Clients.Elasticsearch.Duration value)
	{
		Instance.Pivot = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DateDistanceFeatureQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}