// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.DateDecayFunctionConverter))]
public sealed partial class DateDecayFunction : Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDecayFunction(Elastic.Clients.Elasticsearch.Field field, Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> placement)
	{
		Field = field;
		Placement = placement;
	}
#if NET7_0_OR_GREATER
	public DateDecayFunction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DateDecayFunction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DateDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? MultiValueMode { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> Placement { get; set; }

	string Elastic.Clients.Elasticsearch.QueryDsl.IDecayFunction.Type => "date";
}

public readonly partial struct DateDecayFunctionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDecayFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> MultiValueMode(Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? value)
	{
		Instance.MultiValueMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> Placement(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> value)
	{
		Instance.Placement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> Placement()
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument> Placement(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor>? action)
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct DateDecayFunctionDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DateDecayFunctionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction instance) => new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines how the distance is calculated when a field used for computing the decay contains multiple values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor MultiValueMode(Elastic.Clients.Elasticsearch.QueryDsl.MultiValueMode? value)
	{
		Instance.MultiValueMode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor Placement(Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacement<Elastic.Clients.Elasticsearch.DateMath, Elastic.Clients.Elasticsearch.Duration> value)
	{
		Instance.Placement = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor Placement()
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor Placement(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor>? action)
	{
		Instance.Placement = Elastic.Clients.Elasticsearch.QueryDsl.DecayPlacementOfDateMathDurationDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunctionDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.DateDecayFunction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}