// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.ConstantScoreQueryConverter))]
public sealed partial class ConstantScoreQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ConstantScoreQuery(Elastic.Clients.Elasticsearch.QueryDsl.Query filter)
	{
		Filter = filter;
	}
#if NET7_0_OR_GREATER
	public ConstantScoreQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ConstantScoreQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ConstantScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Filter { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct ConstantScoreQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ConstantScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ConstantScoreQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ConstantScoreQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ConstantScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ConstantScoreQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter query you wish to run. Any returned documents must match this query.
	/// Filter queries do not calculate relevance scores.
	/// To speed up performance, Elasticsearch automatically caches frequently used filter queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.ConstantScoreQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}