// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.CommonTermsQueryConverter))]
public sealed partial class CommonTermsQuery
{
	[System.Obsolete("The type contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CommonTermsQuery(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonTermsQuery(Elastic.Clients.Elasticsearch.Field field, string query)
	{
		Field = field;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public CommonTermsQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CommonTermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }
	public double? CutoffFrequency { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? HighFreqOperator { get; set; }
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? LowFreqOperator { get; set; }
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct CommonTermsQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonTermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonTermsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> CutoffFrequency(double? value)
	{
		Instance.CutoffFrequency = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> HighFreqOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.HighFreqOperator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> LowFreqOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.LowFreqOperator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CommonTermsQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonTermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CommonTermsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor CutoffFrequency(double? value)
	{
		Instance.CutoffFrequency = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor HighFreqOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.HighFreqOperator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor LowFreqOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.LowFreqOperator = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.CommonTermsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}