// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.CombinedFieldsQueryConverter))]
public sealed partial class CombinedFieldsQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Fields fields, string query)
	{
		Fields = fields;
		Query = query;
	}
#if NET7_0_OR_GREATER
	public CombinedFieldsQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CombinedFieldsQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If true, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public bool? AutoGenerateSynonymsPhraseQuery { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// List of fields to search. Field wildcard patterns are allowed. Only <c>text</c> fields are supported, and they must all have the same search <c>analyzer</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Fields Fields { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsOperator? Operator { get; set; }

	/// <summary>
	/// <para>
	/// Text to search for in the provided <c>fields</c>.
	/// The <c>combined_fields</c> query analyzes the provided text before performing a search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the analyzer removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsZeroTerms? ZeroTermsQuery { get; set; }
}

public readonly partial struct CombinedFieldsQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CombinedFieldsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CombinedFieldsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of fields to search. Field wildcard patterns are allowed. Only <c>text</c> fields are supported, and they must all have the same search <c>analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of fields to search. Field wildcard patterns are allowed. Only <c>text</c> fields are supported, and they must all have the same search <c>analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> Operator(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsOperator? value)
	{
		Instance.Operator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to search for in the provided <c>fields</c>.
	/// The <c>combined_fields</c> query analyzes the provided text before performing a search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the analyzer removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument> ZeroTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsZeroTerms? value)
	{
		Instance.ZeroTermsQuery = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct CombinedFieldsQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CombinedFieldsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CombinedFieldsQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, match phrase queries are automatically created for multi-term synonyms.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor AutoGenerateSynonymsPhraseQuery(bool? value = true)
	{
		Instance.AutoGenerateSynonymsPhraseQuery = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of fields to search. Field wildcard patterns are allowed. Only <c>text</c> fields are supported, and they must all have the same search <c>analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of fields to search. Field wildcard patterns are allowed. Only <c>text</c> fields are supported, and they must all have the same search <c>analyzer</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum number of clauses that must match for a document to be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boolean logic used to interpret text in the query value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor Operator(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsOperator? value)
	{
		Instance.Operator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to search for in the provided <c>fields</c>.
	/// The <c>combined_fields</c> query analyzes the provided text before performing a search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether no documents are returned if the analyzer removes all tokens, such as when using a <c>stop</c> filter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor ZeroTermsQuery(Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsZeroTerms? value)
	{
		Instance.ZeroTermsQuery = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.CombinedFieldsQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}