// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl.Json;

public sealed partial class ChildScoreModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAvg = System.Text.Json.JsonEncodedText.Encode("avg");
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");
	private static readonly System.Text.Json.JsonEncodedText MemberSum = System.Text.Json.JsonEncodedText.Encode("sum");

	public override Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAvg))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Avg;
		}

		if (reader.ValueTextEquals(MemberMax))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Max;
		}

		if (reader.ValueTextEquals(MemberMin))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Min;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.None;
		}

		if (reader.ValueTextEquals(MemberSum))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Sum;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAvg.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Avg;
		}

		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Max;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Min;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.None;
		}

		if (string.Equals(value, MemberSum.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Sum;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Avg:
				writer.WriteStringValue(MemberAvg);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Min:
				writer.WriteStringValue(MemberMin);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode.Sum:
				writer.WriteStringValue(MemberSum);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.QueryDsl.ChildScoreMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}