// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.BoostingQueryConverter))]
public sealed partial class BoostingQuery
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoostingQuery(Elastic.Clients.Elasticsearch.QueryDsl.Query negative, double negativeBoost, Elastic.Clients.Elasticsearch.QueryDsl.Query positive)
	{
		Negative = negative;
		NegativeBoost = negativeBoost;
		Positive = positive;
	}
#if NET7_0_OR_GREATER
	public BoostingQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BoostingQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BoostingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Negative { get; set; }

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the <c>negative</c> query.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double NegativeBoost { get; set; }

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryDsl.Query Positive { get; set; }
	public string? QueryName { get; set; }
}

public readonly partial struct BoostingQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoostingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoostingQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> Negative(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Negative = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> Negative(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Negative = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the <c>negative</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> NegativeBoost(double value)
	{
		Instance.NegativeBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> Positive(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Positive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> Positive(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Positive = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct BoostingQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoostingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoostingQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Negative(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Negative = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Negative(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Negative = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to decrease the relevance score of matching documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Negative<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Negative = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the <c>negative</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor NegativeBoost(double value)
	{
		Instance.NegativeBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Positive(Elastic.Clients.Elasticsearch.QueryDsl.Query value)
	{
		Instance.Positive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Positive(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Positive = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Any returned documents must match this query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor Positive<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Positive = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.BoostingQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}