// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.QueryDsl;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.QueryDsl.Json.BoolQueryConverter))]
public partial class BoolQuery
{
#if NET7_0_OR_GREATER
	public BoolQuery()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public BoolQuery()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public float? Boost { get; set; }

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the number or percentage of <c>should</c> clauses returned documents must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.MinimumShouldMatch? MinimumShouldMatch { get; set; }

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Must { get; set; }

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? MustNot { get; set; }
	public string? QueryName { get; set; }

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Should { get; set; }
}

public readonly partial struct BoolQueryDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoolQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoolQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the number or percentage of <c>should</c> clauses returned documents must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Must(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Must = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Must(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Must = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Must(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Must = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> MustNot(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.MustNot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> MustNot(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.MustNot = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> MustNot(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.MustNot = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Should(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Should = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Should(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Should = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument> Should(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Should = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct BoolQueryDescriptor
{
	internal Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoolQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BoolQueryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor(Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery instance) => new Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Floating point number used to decrease or increase the relevance scores of the query.
	/// Boost values are relative to the default value of 1.0.
	/// A boost value between 0 and 1.0 decreases the relevance score.
	/// A value greater than 1.0 increases the relevance score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Boost(float? value)
	{
		Instance.Boost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents.
	/// However, unlike <c>must</c>, the score of the query will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the number or percentage of <c>should</c> clauses returned documents must match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor MinimumShouldMatch(Elastic.Clients.Elasticsearch.MinimumShouldMatch? value)
	{
		Instance.MinimumShouldMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Must(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Must = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Must(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Must = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Must(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Must = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must appear in matching documents and will contribute to the score.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Must<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Must = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor MustNot(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.MustNot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor MustNot(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.MustNot = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor MustNot(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.MustNot = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) must not appear in the matching documents.
	/// Because scoring is ignored, a score of <c>0</c> is returned for all documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor MustNot<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.MustNot = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor QueryName(string? value)
	{
		Instance.QueryName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Should(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Should = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Should(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Should = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Should(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Should = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The clause (query) should appear in the matching document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor Should<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Should = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery Build(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.QueryDsl.BoolQueryDescriptor(new Elastic.Clients.Elasticsearch.QueryDsl.BoolQuery(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}