// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.QueryCacheStatsConverter))]
public sealed partial class QueryCacheStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryCacheStats(long cacheCount, long cacheSize, long evictions, long hitCount, long memorySizeInBytes, long missCount, long totalCount)
	{
		CacheCount = cacheCount;
		CacheSize = cacheSize;
		Evictions = evictions;
		HitCount = hitCount;
		MemorySizeInBytes = memorySizeInBytes;
		MissCount = missCount;
		TotalCount = totalCount;
	}
#if NET7_0_OR_GREATER
	public QueryCacheStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public QueryCacheStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryCacheStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of entries added to the query cache across all shards assigned to selected nodes.
	/// This number includes current and evicted entries.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long CacheCount { get; set; }

	/// <summary>
	/// <para>
	/// Total number of entries currently in the query cache across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long CacheSize { get; set; }

	/// <summary>
	/// <para>
	/// Total number of query cache evictions across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Evictions { get; set; }

	/// <summary>
	/// <para>
	/// Total count of query cache hits across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long HitCount { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of memory used for the query cache across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MemorySize { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory used for the query cache across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MemorySizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total count of query cache misses across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MissCount { get; set; }

	/// <summary>
	/// <para>
	/// Total count of hits and misses in the query cache across all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalCount { get; set; }
}