// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.PinnedRetrieverConverter))]
public sealed partial class PinnedRetriever
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PinnedRetriever(Elastic.Clients.Elasticsearch.Retriever retriever)
	{
		Retriever = retriever;
	}
#if NET7_0_OR_GREATER
	public PinnedRetriever()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PinnedRetriever()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PinnedRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SpecifiedDocument>? Docs { get; set; }

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }
	public System.Collections.Generic.ICollection<string>? Ids { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public float? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public string? Name { get; set; }
	public int? RankWindowSize { get; set; }

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Retriever Retriever { get; set; }
}

public readonly partial struct PinnedRetrieverDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.PinnedRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PinnedRetrieverDescriptor(Elastic.Clients.Elasticsearch.PinnedRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PinnedRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument>(Elastic.Clients.Elasticsearch.PinnedRetriever instance) => new Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SpecifiedDocument>? value)
	{
		Instance.Docs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Docs(params Elastic.Clients.Elasticsearch.SpecifiedDocument[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Docs(params System.Action<Elastic.Clients.Elasticsearch.SpecifiedDocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SpecifiedDocument>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SpecifiedDocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Ids(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Ids = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Ids(params string[] values)
	{
		Instance.Ids = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Retriever(Elastic.Clients.Elasticsearch.Retriever value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument> Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.PinnedRetriever Build(System.Action<Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct PinnedRetrieverDescriptor
{
	internal Elastic.Clients.Elasticsearch.PinnedRetriever Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PinnedRetrieverDescriptor(Elastic.Clients.Elasticsearch.PinnedRetriever instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PinnedRetrieverDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor(Elastic.Clients.Elasticsearch.PinnedRetriever instance) => new Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SpecifiedDocument>? value)
	{
		Instance.Docs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Docs(params Elastic.Clients.Elasticsearch.SpecifiedDocument[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Docs(params System.Action<Elastic.Clients.Elasticsearch.SpecifiedDocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SpecifiedDocument>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SpecifiedDocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query to filter the documents that can match.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Ids(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Ids = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Ids(params string[] values)
	{
		Instance.Ids = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are not included in the top documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor MinScore(float? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retriever name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor RankWindowSize(int? value)
	{
		Instance.RankWindowSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Retriever(Elastic.Clients.Elasticsearch.Retriever value)
	{
		Instance.Retriever = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Retriever(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Inner retriever.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor Retriever<T>(System.Action<Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>> action)
	{
		Instance.Retriever = Elastic.Clients.Elasticsearch.RetrieverDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.PinnedRetriever Build(System.Action<Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.PinnedRetrieverDescriptor(new Elastic.Clients.Elasticsearch.PinnedRetriever(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}