// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class NormalizationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Normalization>
{
	private static readonly System.Text.Json.JsonEncodedText MemberH1 = System.Text.Json.JsonEncodedText.Encode("h1");
	private static readonly System.Text.Json.JsonEncodedText MemberH2 = System.Text.Json.JsonEncodedText.Encode("h2");
	private static readonly System.Text.Json.JsonEncodedText MemberH3 = System.Text.Json.JsonEncodedText.Encode("h3");
	private static readonly System.Text.Json.JsonEncodedText MemberNo = System.Text.Json.JsonEncodedText.Encode("no");
	private static readonly System.Text.Json.JsonEncodedText MemberZ = System.Text.Json.JsonEncodedText.Encode("z");

	public override Elastic.Clients.Elasticsearch.Normalization Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberH1))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H1;
		}

		if (reader.ValueTextEquals(MemberH2))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H2;
		}

		if (reader.ValueTextEquals(MemberH3))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H3;
		}

		if (reader.ValueTextEquals(MemberNo))
		{
			return Elastic.Clients.Elasticsearch.Normalization.No;
		}

		if (reader.ValueTextEquals(MemberZ))
		{
			return Elastic.Clients.Elasticsearch.Normalization.Z;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberH1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H1;
		}

		if (string.Equals(value, MemberH2.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H2;
		}

		if (string.Equals(value, MemberH3.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Normalization.H3;
		}

		if (string.Equals(value, MemberNo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Normalization.No;
		}

		if (string.Equals(value, MemberZ.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Normalization.Z;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Normalization)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Normalization value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Normalization.H1:
				writer.WriteStringValue(MemberH1);
				break;
			case Elastic.Clients.Elasticsearch.Normalization.H2:
				writer.WriteStringValue(MemberH2);
				break;
			case Elastic.Clients.Elasticsearch.Normalization.H3:
				writer.WriteStringValue(MemberH3);
				break;
			case Elastic.Clients.Elasticsearch.Normalization.No:
				writer.WriteStringValue(MemberNo);
				break;
			case Elastic.Clients.Elasticsearch.Normalization.Z:
				writer.WriteStringValue(MemberZ);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Normalization)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Normalization ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Normalization value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}