// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.TransportConverter))]
public sealed partial class Transport
{
#if NET7_0_OR_GREATER
	public Transport()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Transport()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Transport(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The distribution of the time spent handling each inbound message on a transport thread, represented as a histogram.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? InboundHandlingTimeHistogram { get; set; }

	/// <summary>
	/// <para>
	/// The distribution of the time spent sending each outbound transport message on a transport thread, represented as a histogram.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? OutboundHandlingTimeHistogram { get; set; }

	/// <summary>
	/// <para>
	/// Total number of RX (receive) packets received by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public long? RxCount { get; set; }

	/// <summary>
	/// <para>
	/// Size of RX packets received by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public string? RxSize { get; set; }

	/// <summary>
	/// <para>
	/// Size, in bytes, of RX packets received by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public long? RxSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Current number of inbound TCP connections used for internal communication between nodes.
	/// </para>
	/// </summary>
	public int? ServerOpen { get; set; }

	/// <summary>
	/// <para>
	/// The cumulative number of outbound transport connections that this node has opened since it started.
	/// Each transport connection may comprise multiple TCP connections but is only counted once in this statistic.
	/// Transport connections are typically long-lived so this statistic should remain constant in a stable cluster.
	/// </para>
	/// </summary>
	public long? TotalOutboundConnections { get; set; }

	/// <summary>
	/// <para>
	/// Total number of TX (transmit) packets sent by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public long? TxCount { get; set; }

	/// <summary>
	/// <para>
	/// Size of TX packets sent by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public string? TxSize { get; set; }

	/// <summary>
	/// <para>
	/// Size, in bytes, of TX packets sent by the node during internal cluster communication.
	/// </para>
	/// </summary>
	public long? TxSizeInBytes { get; set; }
}