// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class TransportConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.Transport>
{
	private static readonly System.Text.Json.JsonEncodedText PropInboundHandlingTimeHistogram = System.Text.Json.JsonEncodedText.Encode("inbound_handling_time_histogram");
	private static readonly System.Text.Json.JsonEncodedText PropOutboundHandlingTimeHistogram = System.Text.Json.JsonEncodedText.Encode("outbound_handling_time_histogram");
	private static readonly System.Text.Json.JsonEncodedText PropRxCount = System.Text.Json.JsonEncodedText.Encode("rx_count");
	private static readonly System.Text.Json.JsonEncodedText PropRxSize = System.Text.Json.JsonEncodedText.Encode("rx_size");
	private static readonly System.Text.Json.JsonEncodedText PropRxSizeInBytes = System.Text.Json.JsonEncodedText.Encode("rx_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropServerOpen = System.Text.Json.JsonEncodedText.Encode("server_open");
	private static readonly System.Text.Json.JsonEncodedText PropTotalOutboundConnections = System.Text.Json.JsonEncodedText.Encode("total_outbound_connections");
	private static readonly System.Text.Json.JsonEncodedText PropTxCount = System.Text.Json.JsonEncodedText.Encode("tx_count");
	private static readonly System.Text.Json.JsonEncodedText PropTxSize = System.Text.Json.JsonEncodedText.Encode("tx_size");
	private static readonly System.Text.Json.JsonEncodedText PropTxSizeInBytes = System.Text.Json.JsonEncodedText.Encode("tx_size_in_bytes");

	public override Elastic.Clients.Elasticsearch.Nodes.Transport Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>?> propInboundHandlingTimeHistogram = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>?> propOutboundHandlingTimeHistogram = default;
		LocalJsonValue<long?> propRxCount = default;
		LocalJsonValue<string?> propRxSize = default;
		LocalJsonValue<long?> propRxSizeInBytes = default;
		LocalJsonValue<int?> propServerOpen = default;
		LocalJsonValue<long?> propTotalOutboundConnections = default;
		LocalJsonValue<long?> propTxCount = default;
		LocalJsonValue<string?> propTxSize = default;
		LocalJsonValue<long?> propTxSizeInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propInboundHandlingTimeHistogram.TryReadProperty(ref reader, options, PropInboundHandlingTimeHistogram, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>(o, null)))
			{
				continue;
			}

			if (propOutboundHandlingTimeHistogram.TryReadProperty(ref reader, options, PropOutboundHandlingTimeHistogram, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>(o, null)))
			{
				continue;
			}

			if (propRxCount.TryReadProperty(ref reader, options, PropRxCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRxSize.TryReadProperty(ref reader, options, PropRxSize, null))
			{
				continue;
			}

			if (propRxSizeInBytes.TryReadProperty(ref reader, options, PropRxSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propServerOpen.TryReadProperty(ref reader, options, PropServerOpen, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTotalOutboundConnections.TryReadProperty(ref reader, options, PropTotalOutboundConnections, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTxCount.TryReadProperty(ref reader, options, PropTxCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTxSize.TryReadProperty(ref reader, options, PropTxSize, null))
			{
				continue;
			}

			if (propTxSizeInBytes.TryReadProperty(ref reader, options, PropTxSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.Transport(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			InboundHandlingTimeHistogram = propInboundHandlingTimeHistogram.Value,
			OutboundHandlingTimeHistogram = propOutboundHandlingTimeHistogram.Value,
			RxCount = propRxCount.Value,
			RxSize = propRxSize.Value,
			RxSizeInBytes = propRxSizeInBytes.Value,
			ServerOpen = propServerOpen.Value,
			TotalOutboundConnections = propTotalOutboundConnections.Value,
			TxCount = propTxCount.Value,
			TxSize = propTxSize.Value,
			TxSizeInBytes = propTxSizeInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.Transport value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropInboundHandlingTimeHistogram, value.InboundHandlingTimeHistogram, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>(o, v, null));
		writer.WriteProperty(options, PropOutboundHandlingTimeHistogram, value.OutboundHandlingTimeHistogram, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Nodes.TransportHistogram>(o, v, null));
		writer.WriteProperty(options, PropRxCount, value.RxCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRxSize, value.RxSize, null, null);
		writer.WriteProperty(options, PropRxSizeInBytes, value.RxSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropServerOpen, value.ServerOpen, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTotalOutboundConnections, value.TotalOutboundConnections, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTxCount, value.TxCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTxSize, value.TxSize, null, null);
		writer.WriteProperty(options, PropTxSizeInBytes, value.TxSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}