// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.ThreadCountConverter))]
public sealed partial class ThreadCount
{
#if NET7_0_OR_GREATER
	public ThreadCount()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ThreadCount()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ThreadCount(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of active threads in the thread pool.
	/// </para>
	/// </summary>
	public long? Active { get; set; }

	/// <summary>
	/// <para>
	/// Number of tasks completed by the thread pool executor.
	/// </para>
	/// </summary>
	public long? Completed { get; set; }

	/// <summary>
	/// <para>
	/// Highest number of active threads in the thread pool.
	/// </para>
	/// </summary>
	public long? Largest { get; set; }

	/// <summary>
	/// <para>
	/// Number of tasks in queue for the thread pool.
	/// </para>
	/// </summary>
	public long? Queue { get; set; }

	/// <summary>
	/// <para>
	/// Number of tasks rejected by the thread pool executor.
	/// </para>
	/// </summary>
	public long? Rejected { get; set; }

	/// <summary>
	/// <para>
	/// Number of threads in the thread pool.
	/// </para>
	/// </summary>
	public long? Threads { get; set; }
}