// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class StatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.Stats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAdaptiveSelection = System.Text.Json.JsonEncodedText.Encode("adaptive_selection");
	private static readonly System.Text.Json.JsonEncodedText PropAttributes = System.Text.Json.JsonEncodedText.Encode("attributes");
	private static readonly System.Text.Json.JsonEncodedText PropBreakers = System.Text.Json.JsonEncodedText.Encode("breakers");
	private static readonly System.Text.Json.JsonEncodedText PropDiscovery = System.Text.Json.JsonEncodedText.Encode("discovery");
	private static readonly System.Text.Json.JsonEncodedText PropFs = System.Text.Json.JsonEncodedText.Encode("fs");
	private static readonly System.Text.Json.JsonEncodedText PropHost = System.Text.Json.JsonEncodedText.Encode("host");
	private static readonly System.Text.Json.JsonEncodedText PropHttp = System.Text.Json.JsonEncodedText.Encode("http");
	private static readonly System.Text.Json.JsonEncodedText PropIndexingPressure = System.Text.Json.JsonEncodedText.Encode("indexing_pressure");
	private static readonly System.Text.Json.JsonEncodedText PropIndices = System.Text.Json.JsonEncodedText.Encode("indices");
	private static readonly System.Text.Json.JsonEncodedText PropIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText PropIp = System.Text.Json.JsonEncodedText.Encode("ip");
	private static readonly System.Text.Json.JsonEncodedText PropJvm = System.Text.Json.JsonEncodedText.Encode("jvm");
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropOs = System.Text.Json.JsonEncodedText.Encode("os");
	private static readonly System.Text.Json.JsonEncodedText PropProcess = System.Text.Json.JsonEncodedText.Encode("process");
	private static readonly System.Text.Json.JsonEncodedText PropRoles = System.Text.Json.JsonEncodedText.Encode("roles");
	private static readonly System.Text.Json.JsonEncodedText PropScript = System.Text.Json.JsonEncodedText.Encode("script");
	private static readonly System.Text.Json.JsonEncodedText PropScriptCache = System.Text.Json.JsonEncodedText.Encode("script_cache");
	private static readonly System.Text.Json.JsonEncodedText PropThreadPool = System.Text.Json.JsonEncodedText.Encode("thread_pool");
	private static readonly System.Text.Json.JsonEncodedText PropTimestamp = System.Text.Json.JsonEncodedText.Encode("timestamp");
	private static readonly System.Text.Json.JsonEncodedText PropTransport = System.Text.Json.JsonEncodedText.Encode("transport");
	private static readonly System.Text.Json.JsonEncodedText PropTransportAddress = System.Text.Json.JsonEncodedText.Encode("transport_address");

	public override Elastic.Clients.Elasticsearch.Nodes.Stats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>?> propAdaptiveSelection = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, string>?> propAttributes = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.Breaker>?> propBreakers = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Discovery?> propDiscovery = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.FileSystem?> propFs = default;
		LocalJsonValue<string?> propHost = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Http?> propHttp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.IndexingPressure?> propIndexingPressure = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.ShardStats?> propIndices = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Ingest?> propIngest = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propIp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Jvm?> propJvm = default;
		LocalJsonValue<string?> propName = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.OperatingSystem?> propOs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Process?> propProcess = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole>?> propRoles = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Scripting?> propScript = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>>?> propScriptCache = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.ThreadCount>?> propThreadPool = default;
		LocalJsonValue<long?> propTimestamp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.Transport?> propTransport = default;
		LocalJsonValue<string?> propTransportAddress = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAdaptiveSelection.TryReadProperty(ref reader, options, PropAdaptiveSelection, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>(o, null, null)))
			{
				continue;
			}

			if (propAttributes.TryReadProperty(ref reader, options, PropAttributes, static System.Collections.Generic.IReadOnlyDictionary<string, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, string>(o, null, null)))
			{
				continue;
			}

			if (propBreakers.TryReadProperty(ref reader, options, PropBreakers, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.Breaker>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.Breaker>(o, null, null)))
			{
				continue;
			}

			if (propDiscovery.TryReadProperty(ref reader, options, PropDiscovery, null))
			{
				continue;
			}

			if (propFs.TryReadProperty(ref reader, options, PropFs, null))
			{
				continue;
			}

			if (propHost.TryReadProperty(ref reader, options, PropHost, null))
			{
				continue;
			}

			if (propHttp.TryReadProperty(ref reader, options, PropHttp, null))
			{
				continue;
			}

			if (propIndexingPressure.TryReadProperty(ref reader, options, PropIndexingPressure, null))
			{
				continue;
			}

			if (propIndices.TryReadProperty(ref reader, options, PropIndices, null))
			{
				continue;
			}

			if (propIngest.TryReadProperty(ref reader, options, PropIngest, null))
			{
				continue;
			}

			if (propIp.TryReadProperty(ref reader, options, PropIp, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propJvm.TryReadProperty(ref reader, options, PropJvm, null))
			{
				continue;
			}

			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propOs.TryReadProperty(ref reader, options, PropOs, null))
			{
				continue;
			}

			if (propProcess.TryReadProperty(ref reader, options, PropProcess, null))
			{
				continue;
			}

			if (propRoles.TryReadProperty(ref reader, options, PropRoles, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.NodeRole>(o, null)))
			{
				continue;
			}

			if (propScript.TryReadProperty(ref reader, options, PropScript, null))
			{
				continue;
			}

			if (propScriptCache.TryReadProperty(ref reader, options, PropScriptCache, static System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>>(o, null, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>(o, null)!)))
			{
				continue;
			}

			if (propThreadPool.TryReadProperty(ref reader, options, PropThreadPool, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.ThreadCount>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.ThreadCount>(o, null, null)))
			{
				continue;
			}

			if (propTimestamp.TryReadProperty(ref reader, options, PropTimestamp, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTransport.TryReadProperty(ref reader, options, PropTransport, null))
			{
				continue;
			}

			if (propTransportAddress.TryReadProperty(ref reader, options, PropTransportAddress, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.Stats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AdaptiveSelection = propAdaptiveSelection.Value,
			Attributes = propAttributes.Value,
			Breakers = propBreakers.Value,
			Discovery = propDiscovery.Value,
			Fs = propFs.Value,
			Host = propHost.Value,
			Http = propHttp.Value,
			IndexingPressure = propIndexingPressure.Value,
			Indices = propIndices.Value,
			Ingest = propIngest.Value,
			Ip = propIp.Value,
			Jvm = propJvm.Value,
			Name = propName.Value,
			Os = propOs.Value,
			Process = propProcess.Value,
			Roles = propRoles.Value,
			Script = propScript.Value,
			ScriptCache = propScriptCache.Value,
			ThreadPool = propThreadPool.Value,
			Timestamp = propTimestamp.Value,
			Transport = propTransport.Value,
			TransportAddress = propTransportAddress.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.Stats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAdaptiveSelection, value.AdaptiveSelection, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.AdaptiveSelection>(o, v, null, null));
		writer.WriteProperty(options, PropAttributes, value.Attributes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, string>? v) => w.WriteDictionaryValue<string, string>(o, v, null, null));
		writer.WriteProperty(options, PropBreakers, value.Breakers, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.Breaker>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.Breaker>(o, v, null, null));
		writer.WriteProperty(options, PropDiscovery, value.Discovery, null, null);
		writer.WriteProperty(options, PropFs, value.Fs, null, null);
		writer.WriteProperty(options, PropHost, value.Host, null, null);
		writer.WriteProperty(options, PropHttp, value.Http, null, null);
		writer.WriteProperty(options, PropIndexingPressure, value.IndexingPressure, null, null);
		writer.WriteProperty(options, PropIndices, value.Indices, null, null);
		writer.WriteProperty(options, PropIngest, value.Ingest, null, null);
		writer.WriteProperty(options, PropIp, value.Ip, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropJvm, value.Jvm, null, null);
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropOs, value.Os, null, null);
		writer.WriteProperty(options, PropProcess, value.Process, null, null);
		writer.WriteProperty(options, PropRoles, value.Roles, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.NodeRole>(o, v, null));
		writer.WriteProperty(options, PropScript, value.Script, null, null);
		writer.WriteProperty(options, PropScriptCache, value.ScriptCache, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>>? v) => w.WriteDictionaryValue<string, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Nodes.ScriptCache> v) => w.WriteSingleOrManyCollectionValue<Elastic.Clients.Elasticsearch.Nodes.ScriptCache>(o, v, null)));
		writer.WriteProperty(options, PropThreadPool, value.ThreadPool, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.ThreadCount>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Nodes.ThreadCount>(o, v, null, null));
		writer.WriteProperty(options, PropTimestamp, value.Timestamp, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTransport, value.Transport, null, null);
		writer.WriteProperty(options, PropTransportAddress, value.TransportAddress, null, null);
		writer.WriteEndObject();
	}
}