// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class SerializedClusterStateDetailConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.SerializedClusterStateDetail>
{
	private static readonly System.Text.Json.JsonEncodedText PropCompressedSize = System.Text.Json.JsonEncodedText.Encode("compressed_size");
	private static readonly System.Text.Json.JsonEncodedText PropCompressedSizeInBytes = System.Text.Json.JsonEncodedText.Encode("compressed_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropUncompressedSize = System.Text.Json.JsonEncodedText.Encode("uncompressed_size");
	private static readonly System.Text.Json.JsonEncodedText PropUncompressedSizeInBytes = System.Text.Json.JsonEncodedText.Encode("uncompressed_size_in_bytes");

	public override Elastic.Clients.Elasticsearch.Nodes.SerializedClusterStateDetail Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propCompressedSize = default;
		LocalJsonValue<long?> propCompressedSizeInBytes = default;
		LocalJsonValue<long?> propCount = default;
		LocalJsonValue<string?> propUncompressedSize = default;
		LocalJsonValue<long?> propUncompressedSizeInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCompressedSize.TryReadProperty(ref reader, options, PropCompressedSize, null))
			{
				continue;
			}

			if (propCompressedSizeInBytes.TryReadProperty(ref reader, options, PropCompressedSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propUncompressedSize.TryReadProperty(ref reader, options, PropUncompressedSize, null))
			{
				continue;
			}

			if (propUncompressedSizeInBytes.TryReadProperty(ref reader, options, PropUncompressedSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.SerializedClusterStateDetail(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CompressedSize = propCompressedSize.Value,
			CompressedSizeInBytes = propCompressedSizeInBytes.Value,
			Count = propCount.Value,
			UncompressedSize = propUncompressedSize.Value,
			UncompressedSizeInBytes = propUncompressedSizeInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.SerializedClusterStateDetail value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCompressedSize, value.CompressedSize, null, null);
		writer.WriteProperty(options, PropCompressedSizeInBytes, value.CompressedSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropCount, value.Count, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropUncompressedSize, value.UncompressedSize, null, null);
		writer.WriteProperty(options, PropUncompressedSizeInBytes, value.UncompressedSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}