// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.ScriptCacheConverter))]
public sealed partial class ScriptCache
{
#if NET7_0_OR_GREATER
	public ScriptCache()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ScriptCache()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ScriptCache(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of times the script cache has evicted old data.
	/// </para>
	/// </summary>
	public long? CacheEvictions { get; set; }

	/// <summary>
	/// <para>
	/// Total number of times the script compilation circuit breaker has limited inline script compilations.
	/// </para>
	/// </summary>
	public long? CompilationLimitTriggered { get; set; }

	/// <summary>
	/// <para>
	/// Total number of inline script compilations performed by the node.
	/// </para>
	/// </summary>
	public long? Compilations { get; set; }
	public string? Context { get; set; }
}