// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.RequestCountsConverter))]
public sealed partial class RequestCounts
{
#if NET7_0_OR_GREATER
	public RequestCounts()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RequestCounts()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RequestCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of Get Blob requests (Azure)
	/// </para>
	/// </summary>
	public long? GetBlob { get; set; }

	/// <summary>
	/// <para>
	/// Number of Get Blob Properties requests (Azure)
	/// </para>
	/// </summary>
	public long? GetBlobProperties { get; set; }

	/// <summary>
	/// <para>
	/// Number of get object requests (GCP, S3)
	/// </para>
	/// </summary>
	public long? GetObject { get; set; }

	/// <summary>
	/// <para>
	/// Number of insert object requests, including simple, multipart and resumable uploads. Resumable uploads
	/// can perform multiple http requests to insert a single object but they are considered as a single request
	/// since they are billed as an individual operation. (GCP)
	/// </para>
	/// </summary>
	public long? InsertObject { get; set; }

	/// <summary>
	/// <para>
	/// Number of List Blobs requests (Azure)
	/// </para>
	/// </summary>
	public long? ListBlobs { get; set; }

	/// <summary>
	/// <para>
	/// Number of list objects requests (GCP, S3)
	/// </para>
	/// </summary>
	public long? ListObjects { get; set; }

	/// <summary>
	/// <para>
	/// Number of Put Blob requests (Azure)
	/// </para>
	/// </summary>
	public long? PutBlob { get; set; }

	/// <summary>
	/// <para>
	/// Number of Put Block (Azure)
	/// </para>
	/// </summary>
	public long? PutBlock { get; set; }

	/// <summary>
	/// <para>
	/// Number of Put Block List requests
	/// </para>
	/// </summary>
	public long? PutBlockList { get; set; }

	/// <summary>
	/// <para>
	/// Number of Multipart requests, including CreateMultipartUpload, UploadPart and CompleteMultipartUpload requests (S3)
	/// </para>
	/// </summary>
	public long? PutMultipartObject { get; set; }

	/// <summary>
	/// <para>
	/// Number of PutObject requests (S3)
	/// </para>
	/// </summary>
	public long? PutObject { get; set; }
}