// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class RequestCountsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.RequestCounts>
{
	private static readonly System.Text.Json.JsonEncodedText PropGetBlob = System.Text.Json.JsonEncodedText.Encode("GetBlob");
	private static readonly System.Text.Json.JsonEncodedText PropGetBlobProperties = System.Text.Json.JsonEncodedText.Encode("GetBlobProperties");
	private static readonly System.Text.Json.JsonEncodedText PropGetObject = System.Text.Json.JsonEncodedText.Encode("GetObject");
	private static readonly System.Text.Json.JsonEncodedText PropInsertObject = System.Text.Json.JsonEncodedText.Encode("InsertObject");
	private static readonly System.Text.Json.JsonEncodedText PropListBlobs = System.Text.Json.JsonEncodedText.Encode("ListBlobs");
	private static readonly System.Text.Json.JsonEncodedText PropListObjects = System.Text.Json.JsonEncodedText.Encode("ListObjects");
	private static readonly System.Text.Json.JsonEncodedText PropPutBlob = System.Text.Json.JsonEncodedText.Encode("PutBlob");
	private static readonly System.Text.Json.JsonEncodedText PropPutBlock = System.Text.Json.JsonEncodedText.Encode("PutBlock");
	private static readonly System.Text.Json.JsonEncodedText PropPutBlockList = System.Text.Json.JsonEncodedText.Encode("PutBlockList");
	private static readonly System.Text.Json.JsonEncodedText PropPutMultipartObject = System.Text.Json.JsonEncodedText.Encode("PutMultipartObject");
	private static readonly System.Text.Json.JsonEncodedText PropPutObject = System.Text.Json.JsonEncodedText.Encode("PutObject");

	public override Elastic.Clients.Elasticsearch.Nodes.RequestCounts Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long?> propGetBlob = default;
		LocalJsonValue<long?> propGetBlobProperties = default;
		LocalJsonValue<long?> propGetObject = default;
		LocalJsonValue<long?> propInsertObject = default;
		LocalJsonValue<long?> propListBlobs = default;
		LocalJsonValue<long?> propListObjects = default;
		LocalJsonValue<long?> propPutBlob = default;
		LocalJsonValue<long?> propPutBlock = default;
		LocalJsonValue<long?> propPutBlockList = default;
		LocalJsonValue<long?> propPutMultipartObject = default;
		LocalJsonValue<long?> propPutObject = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propGetBlob.TryReadProperty(ref reader, options, PropGetBlob, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propGetBlobProperties.TryReadProperty(ref reader, options, PropGetBlobProperties, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propGetObject.TryReadProperty(ref reader, options, PropGetObject, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propInsertObject.TryReadProperty(ref reader, options, PropInsertObject, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propListBlobs.TryReadProperty(ref reader, options, PropListBlobs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propListObjects.TryReadProperty(ref reader, options, PropListObjects, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPutBlob.TryReadProperty(ref reader, options, PropPutBlob, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPutBlock.TryReadProperty(ref reader, options, PropPutBlock, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPutBlockList.TryReadProperty(ref reader, options, PropPutBlockList, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPutMultipartObject.TryReadProperty(ref reader, options, PropPutMultipartObject, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propPutObject.TryReadProperty(ref reader, options, PropPutObject, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.RequestCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			GetBlob = propGetBlob.Value,
			GetBlobProperties = propGetBlobProperties.Value,
			GetObject = propGetObject.Value,
			InsertObject = propInsertObject.Value,
			ListBlobs = propListBlobs.Value,
			ListObjects = propListObjects.Value,
			PutBlob = propPutBlob.Value,
			PutBlock = propPutBlock.Value,
			PutBlockList = propPutBlockList.Value,
			PutMultipartObject = propPutMultipartObject.Value,
			PutObject = propPutObject.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.RequestCounts value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropGetBlob, value.GetBlob, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropGetBlobProperties, value.GetBlobProperties, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropGetObject, value.GetObject, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropInsertObject, value.InsertObject, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropListBlobs, value.ListBlobs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropListObjects, value.ListObjects, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPutBlob, value.PutBlob, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPutBlock, value.PutBlock, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPutBlockList, value.PutBlockList, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPutMultipartObject, value.PutMultipartObject, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropPutObject, value.PutObject, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}