// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.RepositoryMeteringInformationConverter))]
public sealed partial class RepositoryMeteringInformation
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RepositoryMeteringInformation(bool archived, string repositoryEphemeralId, Elastic.Clients.Elasticsearch.Nodes.RepositoryLocation repositoryLocation, string repositoryName, System.DateTimeOffset repositoryStartedAt, string repositoryType, Elastic.Clients.Elasticsearch.Nodes.RequestCounts requestCounts)
	{
		Archived = archived;
		RepositoryEphemeralId = repositoryEphemeralId;
		RepositoryLocation = repositoryLocation;
		RepositoryName = repositoryName;
		RepositoryStartedAt = repositoryStartedAt;
		RepositoryType = repositoryType;
		RequestCounts = requestCounts;
	}
#if NET7_0_OR_GREATER
	public RepositoryMeteringInformation()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RepositoryMeteringInformation()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RepositoryMeteringInformation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// A flag that tells whether or not this object has been archived. When a repository is closed or updated the
	/// repository metering information is archived and kept for a certain period of time. This allows retrieving the
	/// repository metering information of previous repository instantiations.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Archived { get; set; }

	/// <summary>
	/// <para>
	/// The cluster state version when this object was archived, this field can be used as a logical timestamp to delete
	/// all the archived metrics up to an observed version. This field is only present for archived repository metering
	/// information objects. The main purpose of this field is to avoid possible race conditions during repository metering
	/// information deletions, i.e. deleting archived repositories metering information that we haven’t observed yet.
	/// </para>
	/// </summary>
	public long? ClusterVersion { get; set; }

	/// <summary>
	/// <para>
	/// An identifier that changes every time the repository is updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RepositoryEphemeralId { get; set; }

	/// <summary>
	/// <para>
	/// Represents an unique location within the repository.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Nodes.RepositoryLocation RepositoryLocation { get; set; }

	/// <summary>
	/// <para>
	/// Repository name.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RepositoryName { get; set; }

	/// <summary>
	/// <para>
	/// Time the repository was created or updated. Recorded in milliseconds since the Unix Epoch.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset RepositoryStartedAt { get; set; }

	/// <summary>
	/// <para>
	/// Time the repository was deleted or updated. Recorded in milliseconds since the Unix Epoch.
	/// </para>
	/// </summary>
	public System.DateTimeOffset? RepositoryStoppedAt { get; set; }

	/// <summary>
	/// <para>
	/// Repository type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RepositoryType { get; set; }

	/// <summary>
	/// <para>
	/// An object with the number of request performed against the repository grouped by request type.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Nodes.RequestCounts RequestCounts { get; set; }
}