// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class RepositoryMeteringInformationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.RepositoryMeteringInformation>
{
	private static readonly System.Text.Json.JsonEncodedText PropArchived = System.Text.Json.JsonEncodedText.Encode("archived");
	private static readonly System.Text.Json.JsonEncodedText PropClusterVersion = System.Text.Json.JsonEncodedText.Encode("cluster_version");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryEphemeralId = System.Text.Json.JsonEncodedText.Encode("repository_ephemeral_id");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryLocation = System.Text.Json.JsonEncodedText.Encode("repository_location");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryName = System.Text.Json.JsonEncodedText.Encode("repository_name");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryStartedAt = System.Text.Json.JsonEncodedText.Encode("repository_started_at");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryStoppedAt = System.Text.Json.JsonEncodedText.Encode("repository_stopped_at");
	private static readonly System.Text.Json.JsonEncodedText PropRepositoryType = System.Text.Json.JsonEncodedText.Encode("repository_type");
	private static readonly System.Text.Json.JsonEncodedText PropRequestCounts = System.Text.Json.JsonEncodedText.Encode("request_counts");

	public override Elastic.Clients.Elasticsearch.Nodes.RepositoryMeteringInformation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool> propArchived = default;
		LocalJsonValue<long?> propClusterVersion = default;
		LocalJsonValue<string> propRepositoryEphemeralId = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.RepositoryLocation> propRepositoryLocation = default;
		LocalJsonValue<string> propRepositoryName = default;
		LocalJsonValue<System.DateTimeOffset> propRepositoryStartedAt = default;
		LocalJsonValue<System.DateTimeOffset?> propRepositoryStoppedAt = default;
		LocalJsonValue<string> propRepositoryType = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.RequestCounts> propRequestCounts = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propArchived.TryReadProperty(ref reader, options, PropArchived, null))
			{
				continue;
			}

			if (propClusterVersion.TryReadProperty(ref reader, options, PropClusterVersion, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propRepositoryEphemeralId.TryReadProperty(ref reader, options, PropRepositoryEphemeralId, null))
			{
				continue;
			}

			if (propRepositoryLocation.TryReadProperty(ref reader, options, PropRepositoryLocation, null))
			{
				continue;
			}

			if (propRepositoryName.TryReadProperty(ref reader, options, PropRepositoryName, null))
			{
				continue;
			}

			if (propRepositoryStartedAt.TryReadProperty(ref reader, options, PropRepositoryStartedAt, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propRepositoryStoppedAt.TryReadProperty(ref reader, options, PropRepositoryStoppedAt, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propRepositoryType.TryReadProperty(ref reader, options, PropRepositoryType, null))
			{
				continue;
			}

			if (propRequestCounts.TryReadProperty(ref reader, options, PropRequestCounts, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.RepositoryMeteringInformation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Archived = propArchived.Value,
			ClusterVersion = propClusterVersion.Value,
			RepositoryEphemeralId = propRepositoryEphemeralId.Value,
			RepositoryLocation = propRepositoryLocation.Value,
			RepositoryName = propRepositoryName.Value,
			RepositoryStartedAt = propRepositoryStartedAt.Value,
			RepositoryStoppedAt = propRepositoryStoppedAt.Value,
			RepositoryType = propRepositoryType.Value,
			RequestCounts = propRequestCounts.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.RepositoryMeteringInformation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropArchived, value.Archived, null, null);
		writer.WriteProperty(options, PropClusterVersion, value.ClusterVersion, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropRepositoryEphemeralId, value.RepositoryEphemeralId, null, null);
		writer.WriteProperty(options, PropRepositoryLocation, value.RepositoryLocation, null, null);
		writer.WriteProperty(options, PropRepositoryName, value.RepositoryName, null, null);
		writer.WriteProperty(options, PropRepositoryStartedAt, value.RepositoryStartedAt, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropRepositoryStoppedAt, value.RepositoryStoppedAt, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropRepositoryType, value.RepositoryType, null, null);
		writer.WriteProperty(options, PropRequestCounts, value.RequestCounts, null, null);
		writer.WriteEndObject();
	}
}