// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.ProcessConverter))]
public sealed partial class Process
{
#if NET7_0_OR_GREATER
	public Process()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Process()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Process(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains CPU statistics for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.Cpu? Cpu { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of file descriptors allowed on the system, or <c>-1</c> if not supported.
	/// </para>
	/// </summary>
	public int? MaxFileDescriptors { get; set; }

	/// <summary>
	/// <para>
	/// Contains virtual memory statistics for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.MemoryStats? Mem { get; set; }

	/// <summary>
	/// <para>
	/// Number of opened file descriptors associated with the current or <c>-1</c> if not supported.
	/// </para>
	/// </summary>
	public int? OpenFileDescriptors { get; set; }

	/// <summary>
	/// <para>
	/// Last time the statistics were refreshed.
	/// Recorded in milliseconds since the Unix Epoch.
	/// </para>
	/// </summary>
	public long? Timestamp { get; set; }
}