// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.PressureMemoryConverter))]
public sealed partial class PressureMemory
{
#if NET7_0_OR_GREATER
	public PressureMemory()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PressureMemory()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PressureMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Memory consumed by indexing requests in the coordinating, primary, or replica stage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? All { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed, in bytes, by indexing requests in the coordinating, primary, or replica stage.
	/// </para>
	/// </summary>
	public long? AllInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed by indexing requests in the coordinating or primary stage.
	/// This value is not the sum of coordinating and primary as a node can reuse the coordinating memory if the primary stage is executed locally.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? CombinedCoordinatingAndPrimary { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed, in bytes, by indexing requests in the coordinating or primary stage.
	/// This value is not the sum of coordinating and primary as a node can reuse the coordinating memory if the primary stage is executed locally.
	/// </para>
	/// </summary>
	public long? CombinedCoordinatingAndPrimaryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed by indexing requests in the coordinating stage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Coordinating { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed, in bytes, by indexing requests in the coordinating stage.
	/// </para>
	/// </summary>
	public long? CoordinatingInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Number of indexing requests rejected in the coordinating stage.
	/// </para>
	/// </summary>
	public long? CoordinatingRejections { get; set; }
	public long? LargeOperationRejections { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed by indexing requests in the primary stage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Primary { get; set; }
	public long? PrimaryDocumentRejections { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed, in bytes, by indexing requests in the primary stage.
	/// </para>
	/// </summary>
	public long? PrimaryInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Number of indexing requests rejected in the primary stage.
	/// </para>
	/// </summary>
	public long? PrimaryRejections { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed by indexing requests in the replica stage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Replica { get; set; }

	/// <summary>
	/// <para>
	/// Memory consumed, in bytes, by indexing requests in the replica stage.
	/// </para>
	/// </summary>
	public long? ReplicaInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Number of indexing requests rejected in the replica stage.
	/// </para>
	/// </summary>
	public long? ReplicaRejections { get; set; }
}