// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.NodeOperatingSystemInfoConverter))]
public sealed partial class NodeOperatingSystemInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NodeOperatingSystemInfo(string arch, int availableProcessors, string name, string prettyName, System.TimeSpan refreshIntervalInMillis, string version)
	{
		Arch = arch;
		AvailableProcessors = availableProcessors;
		Name = name;
		PrettyName = prettyName;
		RefreshIntervalInMillis = refreshIntervalInMillis;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public NodeOperatingSystemInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public NodeOperatingSystemInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NodeOperatingSystemInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of processors actually used to calculate thread pool size. This number can be set with the node.processors setting of a node and defaults to the number of processors reported by the OS.
	/// </para>
	/// </summary>
	public int? AllocatedProcessors { get; set; }

	/// <summary>
	/// <para>
	/// Name of the JVM architecture (ex: amd64, x86)
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Arch { get; set; }

	/// <summary>
	/// <para>
	/// Number of processors available to the Java virtual machine
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int AvailableProcessors { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoOSCPU? Cpu { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoMemory? Mem { get; set; }

	/// <summary>
	/// <para>
	/// Name of the operating system (ex: Linux, Windows, Mac OS X)
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string PrettyName { get; set; }

	/// <summary>
	/// <para>
	/// Refresh interval for the OS statistics
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan RefreshIntervalInMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoMemory? Swap { get; set; }

	/// <summary>
	/// <para>
	/// Version of the operating system
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Version { get; set; }
}