// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class NodeJvmInfoConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.NodeJvmInfo>
{
	private static readonly System.Text.Json.JsonEncodedText PropGcCollectors = System.Text.Json.JsonEncodedText.Encode("gc_collectors");
	private static readonly System.Text.Json.JsonEncodedText PropInputArguments = System.Text.Json.JsonEncodedText.Encode("input_arguments");
	private static readonly System.Text.Json.JsonEncodedText PropMem = System.Text.Json.JsonEncodedText.Encode("mem");
	private static readonly System.Text.Json.JsonEncodedText PropMemoryPools = System.Text.Json.JsonEncodedText.Encode("memory_pools");
	private static readonly System.Text.Json.JsonEncodedText PropPid = System.Text.Json.JsonEncodedText.Encode("pid");
	private static readonly System.Text.Json.JsonEncodedText PropStartTimeInMillis = System.Text.Json.JsonEncodedText.Encode("start_time_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropUsingBundledJdk = System.Text.Json.JsonEncodedText.Encode("using_bundled_jdk");
	private static readonly System.Text.Json.JsonEncodedText PropUsingCompressedOrdinaryObjectPointers = System.Text.Json.JsonEncodedText.Encode("using_compressed_ordinary_object_pointers");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");
	private static readonly System.Text.Json.JsonEncodedText PropVmName = System.Text.Json.JsonEncodedText.Encode("vm_name");
	private static readonly System.Text.Json.JsonEncodedText PropVmVendor = System.Text.Json.JsonEncodedText.Encode("vm_vendor");
	private static readonly System.Text.Json.JsonEncodedText PropVmVersion = System.Text.Json.JsonEncodedText.Encode("vm_version");

	public override Elastic.Clients.Elasticsearch.Nodes.NodeJvmInfo Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propGcCollectors = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propInputArguments = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoJvmMemory> propMem = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propMemoryPools = default;
		LocalJsonValue<int> propPid = default;
		LocalJsonValue<System.DateTimeOffset> propStartTimeInMillis = default;
		LocalJsonValue<bool> propUsingBundledJdk = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<bool, string>?> propUsingCompressedOrdinaryObjectPointers = default;
		LocalJsonValue<string> propVersion = default;
		LocalJsonValue<string> propVmName = default;
		LocalJsonValue<string> propVmVendor = default;
		LocalJsonValue<string> propVmVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propGcCollectors.TryReadProperty(ref reader, options, PropGcCollectors, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propInputArguments.TryReadProperty(ref reader, options, PropInputArguments, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propMem.TryReadProperty(ref reader, options, PropMem, null))
			{
				continue;
			}

			if (propMemoryPools.TryReadProperty(ref reader, options, PropMemoryPools, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propPid.TryReadProperty(ref reader, options, PropPid, null))
			{
				continue;
			}

			if (propStartTimeInMillis.TryReadProperty(ref reader, options, PropStartTimeInMillis, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propUsingBundledJdk.TryReadProperty(ref reader, options, PropUsingBundledJdk, null))
			{
				continue;
			}

			if (propUsingCompressedOrdinaryObjectPointers.TryReadProperty(ref reader, options, PropUsingCompressedOrdinaryObjectPointers, static Elastic.Clients.Elasticsearch.Union<bool, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<bool, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.True | Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.False, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (propVmName.TryReadProperty(ref reader, options, PropVmName, null))
			{
				continue;
			}

			if (propVmVendor.TryReadProperty(ref reader, options, PropVmVendor, null))
			{
				continue;
			}

			if (propVmVersion.TryReadProperty(ref reader, options, PropVmVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.NodeJvmInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			GcCollectors = propGcCollectors.Value,
			InputArguments = propInputArguments.Value,
			Mem = propMem.Value,
			MemoryPools = propMemoryPools.Value,
			Pid = propPid.Value,
			StartTimeInMillis = propStartTimeInMillis.Value,
			UsingBundledJdk = propUsingBundledJdk.Value,
			UsingCompressedOrdinaryObjectPointers = propUsingCompressedOrdinaryObjectPointers.Value,
			Version = propVersion.Value,
			VmName = propVmName.Value,
			VmVendor = propVmVendor.Value,
			VmVersion = propVmVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.NodeJvmInfo value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropGcCollectors, value.GcCollectors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropInputArguments, value.InputArguments, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropMem, value.Mem, null, null);
		writer.WriteProperty(options, PropMemoryPools, value.MemoryPools, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropPid, value.Pid, null, null);
		writer.WriteProperty(options, PropStartTimeInMillis, value.StartTimeInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropUsingBundledJdk, value.UsingBundledJdk, null, null);
		writer.WriteProperty(options, PropUsingCompressedOrdinaryObjectPointers, value.UsingCompressedOrdinaryObjectPointers, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<bool, string>? v) => w.WriteUnionValue<bool, string>(o, v, null, null));
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteProperty(options, PropVmName, value.VmName, null, null);
		writer.WriteProperty(options, PropVmVendor, value.VmVendor, null, null);
		writer.WriteProperty(options, PropVmVersion, value.VmVersion, null, null);
		writer.WriteEndObject();
	}
}