// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class NodeInfoSettingsIngestConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.NodeInfoSettingsIngest>
{
	private static readonly System.Text.Json.JsonEncodedText PropAppend = System.Text.Json.JsonEncodedText.Encode("append");
	private static readonly System.Text.Json.JsonEncodedText PropAttachment = System.Text.Json.JsonEncodedText.Encode("attachment");
	private static readonly System.Text.Json.JsonEncodedText PropBytes = System.Text.Json.JsonEncodedText.Encode("bytes");
	private static readonly System.Text.Json.JsonEncodedText PropCircle = System.Text.Json.JsonEncodedText.Encode("circle");
	private static readonly System.Text.Json.JsonEncodedText PropConvert = System.Text.Json.JsonEncodedText.Encode("convert");
	private static readonly System.Text.Json.JsonEncodedText PropCsv = System.Text.Json.JsonEncodedText.Encode("csv");
	private static readonly System.Text.Json.JsonEncodedText PropDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText PropDateIndexName = System.Text.Json.JsonEncodedText.Encode("date_index_name");
	private static readonly System.Text.Json.JsonEncodedText PropDissect = System.Text.Json.JsonEncodedText.Encode("dissect");
	private static readonly System.Text.Json.JsonEncodedText PropDotExpander = System.Text.Json.JsonEncodedText.Encode("dot_expander");
	private static readonly System.Text.Json.JsonEncodedText PropDrop = System.Text.Json.JsonEncodedText.Encode("drop");
	private static readonly System.Text.Json.JsonEncodedText PropEnrich = System.Text.Json.JsonEncodedText.Encode("enrich");
	private static readonly System.Text.Json.JsonEncodedText PropFail = System.Text.Json.JsonEncodedText.Encode("fail");
	private static readonly System.Text.Json.JsonEncodedText PropForeach = System.Text.Json.JsonEncodedText.Encode("foreach");
	private static readonly System.Text.Json.JsonEncodedText PropGeoip = System.Text.Json.JsonEncodedText.Encode("geoip");
	private static readonly System.Text.Json.JsonEncodedText PropGrok = System.Text.Json.JsonEncodedText.Encode("grok");
	private static readonly System.Text.Json.JsonEncodedText PropGsub = System.Text.Json.JsonEncodedText.Encode("gsub");
	private static readonly System.Text.Json.JsonEncodedText PropInference = System.Text.Json.JsonEncodedText.Encode("inference");
	private static readonly System.Text.Json.JsonEncodedText PropJoin = System.Text.Json.JsonEncodedText.Encode("join");
	private static readonly System.Text.Json.JsonEncodedText PropJson = System.Text.Json.JsonEncodedText.Encode("json");
	private static readonly System.Text.Json.JsonEncodedText PropKv = System.Text.Json.JsonEncodedText.Encode("kv");
	private static readonly System.Text.Json.JsonEncodedText PropLowercase = System.Text.Json.JsonEncodedText.Encode("lowercase");
	private static readonly System.Text.Json.JsonEncodedText PropPipeline = System.Text.Json.JsonEncodedText.Encode("pipeline");
	private static readonly System.Text.Json.JsonEncodedText PropRemove = System.Text.Json.JsonEncodedText.Encode("remove");
	private static readonly System.Text.Json.JsonEncodedText PropRename = System.Text.Json.JsonEncodedText.Encode("rename");
	private static readonly System.Text.Json.JsonEncodedText PropScript = System.Text.Json.JsonEncodedText.Encode("script");
	private static readonly System.Text.Json.JsonEncodedText PropSet = System.Text.Json.JsonEncodedText.Encode("set");
	private static readonly System.Text.Json.JsonEncodedText PropSetSecurityUser = System.Text.Json.JsonEncodedText.Encode("set_security_user");
	private static readonly System.Text.Json.JsonEncodedText PropSort = System.Text.Json.JsonEncodedText.Encode("sort");
	private static readonly System.Text.Json.JsonEncodedText PropSplit = System.Text.Json.JsonEncodedText.Encode("split");
	private static readonly System.Text.Json.JsonEncodedText PropTrim = System.Text.Json.JsonEncodedText.Encode("trim");
	private static readonly System.Text.Json.JsonEncodedText PropUppercase = System.Text.Json.JsonEncodedText.Encode("uppercase");
	private static readonly System.Text.Json.JsonEncodedText PropUrlDecode = System.Text.Json.JsonEncodedText.Encode("urldecode");
	private static readonly System.Text.Json.JsonEncodedText PropUserAgent = System.Text.Json.JsonEncodedText.Encode("user_agent");

	public override Elastic.Clients.Elasticsearch.Nodes.NodeInfoSettingsIngest Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propAppend = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propAttachment = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propCircle = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propConvert = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propCsv = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propDate = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propDateIndexName = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propDissect = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propDotExpander = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propDrop = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propEnrich = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propFail = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propForeach = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propGeoip = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propGrok = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propGsub = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propInference = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propJoin = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propJson = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propKv = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propLowercase = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propPipeline = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propRemove = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propRename = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propScript = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propSet = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propSetSecurityUser = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propSort = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propSplit = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propTrim = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propUppercase = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propUrlDecode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngestInfo?> propUserAgent = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAppend.TryReadProperty(ref reader, options, PropAppend, null))
			{
				continue;
			}

			if (propAttachment.TryReadProperty(ref reader, options, PropAttachment, null))
			{
				continue;
			}

			if (propBytes.TryReadProperty(ref reader, options, PropBytes, null))
			{
				continue;
			}

			if (propCircle.TryReadProperty(ref reader, options, PropCircle, null))
			{
				continue;
			}

			if (propConvert.TryReadProperty(ref reader, options, PropConvert, null))
			{
				continue;
			}

			if (propCsv.TryReadProperty(ref reader, options, PropCsv, null))
			{
				continue;
			}

			if (propDate.TryReadProperty(ref reader, options, PropDate, null))
			{
				continue;
			}

			if (propDateIndexName.TryReadProperty(ref reader, options, PropDateIndexName, null))
			{
				continue;
			}

			if (propDissect.TryReadProperty(ref reader, options, PropDissect, null))
			{
				continue;
			}

			if (propDotExpander.TryReadProperty(ref reader, options, PropDotExpander, null))
			{
				continue;
			}

			if (propDrop.TryReadProperty(ref reader, options, PropDrop, null))
			{
				continue;
			}

			if (propEnrich.TryReadProperty(ref reader, options, PropEnrich, null))
			{
				continue;
			}

			if (propFail.TryReadProperty(ref reader, options, PropFail, null))
			{
				continue;
			}

			if (propForeach.TryReadProperty(ref reader, options, PropForeach, null))
			{
				continue;
			}

			if (propGeoip.TryReadProperty(ref reader, options, PropGeoip, null))
			{
				continue;
			}

			if (propGrok.TryReadProperty(ref reader, options, PropGrok, null))
			{
				continue;
			}

			if (propGsub.TryReadProperty(ref reader, options, PropGsub, null))
			{
				continue;
			}

			if (propInference.TryReadProperty(ref reader, options, PropInference, null))
			{
				continue;
			}

			if (propJoin.TryReadProperty(ref reader, options, PropJoin, null))
			{
				continue;
			}

			if (propJson.TryReadProperty(ref reader, options, PropJson, null))
			{
				continue;
			}

			if (propKv.TryReadProperty(ref reader, options, PropKv, null))
			{
				continue;
			}

			if (propLowercase.TryReadProperty(ref reader, options, PropLowercase, null))
			{
				continue;
			}

			if (propPipeline.TryReadProperty(ref reader, options, PropPipeline, null))
			{
				continue;
			}

			if (propRemove.TryReadProperty(ref reader, options, PropRemove, null))
			{
				continue;
			}

			if (propRename.TryReadProperty(ref reader, options, PropRename, null))
			{
				continue;
			}

			if (propScript.TryReadProperty(ref reader, options, PropScript, null))
			{
				continue;
			}

			if (propSet.TryReadProperty(ref reader, options, PropSet, null))
			{
				continue;
			}

			if (propSetSecurityUser.TryReadProperty(ref reader, options, PropSetSecurityUser, null))
			{
				continue;
			}

			if (propSort.TryReadProperty(ref reader, options, PropSort, null))
			{
				continue;
			}

			if (propSplit.TryReadProperty(ref reader, options, PropSplit, null))
			{
				continue;
			}

			if (propTrim.TryReadProperty(ref reader, options, PropTrim, null))
			{
				continue;
			}

			if (propUppercase.TryReadProperty(ref reader, options, PropUppercase, null))
			{
				continue;
			}

			if (propUrlDecode.TryReadProperty(ref reader, options, PropUrlDecode, null))
			{
				continue;
			}

			if (propUserAgent.TryReadProperty(ref reader, options, PropUserAgent, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.NodeInfoSettingsIngest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Append = propAppend.Value,
			Attachment = propAttachment.Value,
			Bytes = propBytes.Value,
			Circle = propCircle.Value,
			Convert = propConvert.Value,
			Csv = propCsv.Value,
			Date = propDate.Value,
			DateIndexName = propDateIndexName.Value,
			Dissect = propDissect.Value,
			DotExpander = propDotExpander.Value,
			Drop = propDrop.Value,
			Enrich = propEnrich.Value,
			Fail = propFail.Value,
			Foreach = propForeach.Value,
			Geoip = propGeoip.Value,
			Grok = propGrok.Value,
			Gsub = propGsub.Value,
			Inference = propInference.Value,
			Join = propJoin.Value,
			Json = propJson.Value,
			Kv = propKv.Value,
			Lowercase = propLowercase.Value,
			Pipeline = propPipeline.Value,
			Remove = propRemove.Value,
			Rename = propRename.Value,
			Script = propScript.Value,
			Set = propSet.Value,
			SetSecurityUser = propSetSecurityUser.Value,
			Sort = propSort.Value,
			Split = propSplit.Value,
			Trim = propTrim.Value,
			Uppercase = propUppercase.Value,
			UrlDecode = propUrlDecode.Value,
			UserAgent = propUserAgent.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.NodeInfoSettingsIngest value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAppend, value.Append, null, null);
		writer.WriteProperty(options, PropAttachment, value.Attachment, null, null);
		writer.WriteProperty(options, PropBytes, value.Bytes, null, null);
		writer.WriteProperty(options, PropCircle, value.Circle, null, null);
		writer.WriteProperty(options, PropConvert, value.Convert, null, null);
		writer.WriteProperty(options, PropCsv, value.Csv, null, null);
		writer.WriteProperty(options, PropDate, value.Date, null, null);
		writer.WriteProperty(options, PropDateIndexName, value.DateIndexName, null, null);
		writer.WriteProperty(options, PropDissect, value.Dissect, null, null);
		writer.WriteProperty(options, PropDotExpander, value.DotExpander, null, null);
		writer.WriteProperty(options, PropDrop, value.Drop, null, null);
		writer.WriteProperty(options, PropEnrich, value.Enrich, null, null);
		writer.WriteProperty(options, PropFail, value.Fail, null, null);
		writer.WriteProperty(options, PropForeach, value.Foreach, null, null);
		writer.WriteProperty(options, PropGeoip, value.Geoip, null, null);
		writer.WriteProperty(options, PropGrok, value.Grok, null, null);
		writer.WriteProperty(options, PropGsub, value.Gsub, null, null);
		writer.WriteProperty(options, PropInference, value.Inference, null, null);
		writer.WriteProperty(options, PropJoin, value.Join, null, null);
		writer.WriteProperty(options, PropJson, value.Json, null, null);
		writer.WriteProperty(options, PropKv, value.Kv, null, null);
		writer.WriteProperty(options, PropLowercase, value.Lowercase, null, null);
		writer.WriteProperty(options, PropPipeline, value.Pipeline, null, null);
		writer.WriteProperty(options, PropRemove, value.Remove, null, null);
		writer.WriteProperty(options, PropRename, value.Rename, null, null);
		writer.WriteProperty(options, PropScript, value.Script, null, null);
		writer.WriteProperty(options, PropSet, value.Set, null, null);
		writer.WriteProperty(options, PropSetSecurityUser, value.SetSecurityUser, null, null);
		writer.WriteProperty(options, PropSort, value.Sort, null, null);
		writer.WriteProperty(options, PropSplit, value.Split, null, null);
		writer.WriteProperty(options, PropTrim, value.Trim, null, null);
		writer.WriteProperty(options, PropUppercase, value.Uppercase, null, null);
		writer.WriteProperty(options, PropUrlDecode, value.UrlDecode, null, null);
		writer.WriteProperty(options, PropUserAgent, value.UserAgent, null, null);
		writer.WriteEndObject();
	}
}