// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.NodeInfoConverter))]
public sealed partial class NodeInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public NodeInfo(System.Collections.Generic.IReadOnlyDictionary<string, string> attributes, string buildFlavor, string buildHash, string buildType, System.Collections.Generic.IReadOnlyDictionary<string, int> componentVersions, string host, long indexVersion, string ip, string name, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole> roles, string transportAddress, long transportVersion, string version)
	{
		Attributes = attributes;
		BuildFlavor = buildFlavor;
		BuildHash = buildHash;
		BuildType = buildType;
		ComponentVersions = componentVersions;
		Host = host;
		IndexVersion = indexVersion;
		Ip = ip;
		Name = name;
		Roles = roles;
		TransportAddress = transportAddress;
		TransportVersion = transportVersion;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public NodeInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public NodeInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal NodeInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.NodeInfoAggregation>? Aggregations { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, string> Attributes { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildFlavor { get; set; }

	/// <summary>
	/// <para>
	/// Short hash of the last git commit in this release.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildHash { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildType { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> ComponentVersions { get; set; }

	/// <summary>
	/// <para>
	/// The node’s host name.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Host { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoHttp? Http { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IndexVersion { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoIngest? Ingest { get; set; }

	/// <summary>
	/// <para>
	/// The node’s IP address.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Ip { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeJvmInfo? Jvm { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats>? Modules { get; set; }

	/// <summary>
	/// <para>
	/// The node's name
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeOperatingSystemInfo? Os { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats>? Plugins { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeProcessInfo? Process { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.RemoveClusterServer? RemoteClusterServer { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole> Roles { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoSettings? Settings { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.NodeThreadPoolInfo>? ThreadPool { get; set; }

	/// <summary>
	/// <para>
	/// Total heap allowed to be used to hold recently indexed documents before they must be written to disk. This size is a shared pool across all shards on this node, and is controlled by Indexing Buffer settings.
	/// </para>
	/// </summary>
	public long? TotalIndexingBuffer { get; set; }

	/// <summary>
	/// <para>
	/// Same as total_indexing_buffer, but expressed in bytes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TotalIndexingBufferInBytes { get; set; }
	public Elastic.Clients.Elasticsearch.Nodes.NodeInfoTransport? Transport { get; set; }

	/// <summary>
	/// <para>
	/// Host and port where transport HTTP connections are accepted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string TransportAddress { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TransportVersion { get; set; }

	/// <summary>
	/// <para>
	/// Elasticsearch version running on this node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Version { get; set; }
}