// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class MemoryStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.MemoryStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAdjustedTotalInBytes = System.Text.Json.JsonEncodedText.Encode("adjusted_total_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropFreeInBytes = System.Text.Json.JsonEncodedText.Encode("free_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropResident = System.Text.Json.JsonEncodedText.Encode("resident");
	private static readonly System.Text.Json.JsonEncodedText PropResidentInBytes = System.Text.Json.JsonEncodedText.Encode("resident_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropShare = System.Text.Json.JsonEncodedText.Encode("share");
	private static readonly System.Text.Json.JsonEncodedText PropShareInBytes = System.Text.Json.JsonEncodedText.Encode("share_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalInBytes = System.Text.Json.JsonEncodedText.Encode("total_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVirtual = System.Text.Json.JsonEncodedText.Encode("total_virtual");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVirtualInBytes = System.Text.Json.JsonEncodedText.Encode("total_virtual_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropUsedInBytes = System.Text.Json.JsonEncodedText.Encode("used_in_bytes");

	public override Elastic.Clients.Elasticsearch.Nodes.MemoryStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long?> propAdjustedTotalInBytes = default;
		LocalJsonValue<long?> propFreeInBytes = default;
		LocalJsonValue<string?> propResident = default;
		LocalJsonValue<long?> propResidentInBytes = default;
		LocalJsonValue<string?> propShare = default;
		LocalJsonValue<long?> propShareInBytes = default;
		LocalJsonValue<long?> propTotalInBytes = default;
		LocalJsonValue<string?> propTotalVirtual = default;
		LocalJsonValue<long?> propTotalVirtualInBytes = default;
		LocalJsonValue<long?> propUsedInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAdjustedTotalInBytes.TryReadProperty(ref reader, options, PropAdjustedTotalInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propFreeInBytes.TryReadProperty(ref reader, options, PropFreeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propResident.TryReadProperty(ref reader, options, PropResident, null))
			{
				continue;
			}

			if (propResidentInBytes.TryReadProperty(ref reader, options, PropResidentInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propShare.TryReadProperty(ref reader, options, PropShare, null))
			{
				continue;
			}

			if (propShareInBytes.TryReadProperty(ref reader, options, PropShareInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalInBytes.TryReadProperty(ref reader, options, PropTotalInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalVirtual.TryReadProperty(ref reader, options, PropTotalVirtual, null))
			{
				continue;
			}

			if (propTotalVirtualInBytes.TryReadProperty(ref reader, options, PropTotalVirtualInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propUsedInBytes.TryReadProperty(ref reader, options, PropUsedInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.MemoryStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AdjustedTotalInBytes = propAdjustedTotalInBytes.Value,
			FreeInBytes = propFreeInBytes.Value,
			Resident = propResident.Value,
			ResidentInBytes = propResidentInBytes.Value,
			Share = propShare.Value,
			ShareInBytes = propShareInBytes.Value,
			TotalInBytes = propTotalInBytes.Value,
			TotalVirtual = propTotalVirtual.Value,
			TotalVirtualInBytes = propTotalVirtualInBytes.Value,
			UsedInBytes = propUsedInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.MemoryStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAdjustedTotalInBytes, value.AdjustedTotalInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropFreeInBytes, value.FreeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropResident, value.Resident, null, null);
		writer.WriteProperty(options, PropResidentInBytes, value.ResidentInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropShare, value.Share, null, null);
		writer.WriteProperty(options, PropShareInBytes, value.ShareInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalInBytes, value.TotalInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalVirtual, value.TotalVirtual, null, null);
		writer.WriteProperty(options, PropTotalVirtualInBytes, value.TotalVirtualInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropUsedInBytes, value.UsedInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}