// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.JvmMemoryStatsConverter))]
public sealed partial class JvmMemoryStats
{
#if NET7_0_OR_GREATER
	public JvmMemoryStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public JvmMemoryStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal JvmMemoryStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Amount of memory, in bytes, available for use by the heap.
	/// </para>
	/// </summary>
	public long? HeapCommittedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of memory, available for use by the heap.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? HeapMax { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of memory, in bytes, available for use by the heap.
	/// </para>
	/// </summary>
	public long? HeapMaxInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Memory, in bytes, currently in use by the heap.
	/// </para>
	/// </summary>
	public long? HeapUsedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Percentage of memory currently in use by the heap.
	/// </para>
	/// </summary>
	public long? HeapUsedPercent { get; set; }

	/// <summary>
	/// <para>
	/// Amount of non-heap memory available, in bytes.
	/// </para>
	/// </summary>
	public long? NonHeapCommittedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Non-heap memory used, in bytes.
	/// </para>
	/// </summary>
	public long? NonHeapUsedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about heap memory usage for the node.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.Pool>? Pools { get; set; }
}