// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.JvmConverter))]
public sealed partial class Jvm
{
#if NET7_0_OR_GREATER
	public Jvm()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Jvm()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Jvm(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains statistics about JVM buffer pools for the node.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.NodeBufferPool>? BufferPools { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about classes loaded by JVM for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.JvmClasses? Classes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about JVM garbage collectors for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.GarbageCollector? Gc { get; set; }

	/// <summary>
	/// <para>
	/// Contains JVM memory usage statistics for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.JvmMemoryStats? Mem { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about JVM thread usage for the node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Nodes.JvmThreads? Threads { get; set; }

	/// <summary>
	/// <para>
	/// Last time JVM statistics were refreshed.
	/// </para>
	/// </summary>
	public long? Timestamp { get; set; }

	/// <summary>
	/// <para>
	/// Human-readable JVM uptime.
	/// Only returned if the <c>human</c> query parameter is <c>true</c>.
	/// </para>
	/// </summary>
	public string? Uptime { get; set; }

	/// <summary>
	/// <para>
	/// JVM uptime in milliseconds.
	/// </para>
	/// </summary>
	public long? UptimeInMillis { get; set; }
}