// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.IoStatDeviceConverter))]
public sealed partial class IoStatDevice
{
#if NET7_0_OR_GREATER
	public IoStatDevice()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IoStatDevice()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IoStatDevice(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The Linux device name.
	/// </para>
	/// </summary>
	public string? DeviceName { get; set; }

	/// <summary>
	/// <para>
	/// The total number of read and write operations for the device completed since starting Elasticsearch.
	/// </para>
	/// </summary>
	public long? Operations { get; set; }

	/// <summary>
	/// <para>
	/// The total number of kilobytes read for the device since starting Elasticsearch.
	/// </para>
	/// </summary>
	public long? ReadKilobytes { get; set; }

	/// <summary>
	/// <para>
	/// The total number of read operations for the device completed since starting Elasticsearch.
	/// </para>
	/// </summary>
	public long? ReadOperations { get; set; }

	/// <summary>
	/// <para>
	/// The total number of kilobytes written for the device since starting Elasticsearch.
	/// </para>
	/// </summary>
	public long? WriteKilobytes { get; set; }

	/// <summary>
	/// <para>
	/// The total number of write operations for the device completed since starting Elasticsearch.
	/// </para>
	/// </summary>
	public long? WriteOperations { get; set; }
}