// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes.Json;

public sealed partial class IoStatDeviceConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Nodes.IoStatDevice>
{
	private static readonly System.Text.Json.JsonEncodedText PropDeviceName = System.Text.Json.JsonEncodedText.Encode("device_name");
	private static readonly System.Text.Json.JsonEncodedText PropOperations = System.Text.Json.JsonEncodedText.Encode("operations");
	private static readonly System.Text.Json.JsonEncodedText PropReadKilobytes = System.Text.Json.JsonEncodedText.Encode("read_kilobytes");
	private static readonly System.Text.Json.JsonEncodedText PropReadOperations = System.Text.Json.JsonEncodedText.Encode("read_operations");
	private static readonly System.Text.Json.JsonEncodedText PropWriteKilobytes = System.Text.Json.JsonEncodedText.Encode("write_kilobytes");
	private static readonly System.Text.Json.JsonEncodedText PropWriteOperations = System.Text.Json.JsonEncodedText.Encode("write_operations");

	public override Elastic.Clients.Elasticsearch.Nodes.IoStatDevice Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propDeviceName = default;
		LocalJsonValue<long?> propOperations = default;
		LocalJsonValue<long?> propReadKilobytes = default;
		LocalJsonValue<long?> propReadOperations = default;
		LocalJsonValue<long?> propWriteKilobytes = default;
		LocalJsonValue<long?> propWriteOperations = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDeviceName.TryReadProperty(ref reader, options, PropDeviceName, null))
			{
				continue;
			}

			if (propOperations.TryReadProperty(ref reader, options, PropOperations, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propReadKilobytes.TryReadProperty(ref reader, options, PropReadKilobytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propReadOperations.TryReadProperty(ref reader, options, PropReadOperations, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propWriteKilobytes.TryReadProperty(ref reader, options, PropWriteKilobytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propWriteOperations.TryReadProperty(ref reader, options, PropWriteOperations, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Nodes.IoStatDevice(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			DeviceName = propDeviceName.Value,
			Operations = propOperations.Value,
			ReadKilobytes = propReadKilobytes.Value,
			ReadOperations = propReadOperations.Value,
			WriteKilobytes = propWriteKilobytes.Value,
			WriteOperations = propWriteOperations.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Nodes.IoStatDevice value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDeviceName, value.DeviceName, null, null);
		writer.WriteProperty(options, PropOperations, value.Operations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropReadKilobytes, value.ReadKilobytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropReadOperations, value.ReadOperations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropWriteKilobytes, value.WriteKilobytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropWriteOperations, value.WriteOperations, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}