// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.IngestStatsConverter))]
public sealed partial class IngestStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestStats(long count, long current, long failed, long ingestedAsFirstPipelineInBytes, System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.KeyedProcessor>> processors, long producedAsFirstPipelineInBytes, System.TimeSpan timeInMillis)
	{
		Count = count;
		Current = current;
		Failed = failed;
		IngestedAsFirstPipelineInBytes = ingestedAsFirstPipelineInBytes;
		Processors = processors;
		ProducedAsFirstPipelineInBytes = producedAsFirstPipelineInBytes;
		TimeInMillis = timeInMillis;
	}
#if NET7_0_OR_GREATER
	public IngestStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IngestStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IngestStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of documents ingested during the lifetime of this node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Count { get; set; }

	/// <summary>
	/// <para>
	/// Total number of documents currently being ingested.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Current { get; set; }

	/// <summary>
	/// <para>
	/// Total number of failed ingest operations during the lifetime of this node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Failed { get; set; }

	/// <summary>
	/// <para>
	/// Total number of bytes of all documents ingested by the pipeline.
	/// This field is only present on pipelines which are the first to process a document.
	/// Thus, it is not present on pipelines which only serve as a final pipeline after a default pipeline, a pipeline run after a reroute processor, or pipelines in pipeline processors.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IngestedAsFirstPipelineInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total number of ingest processors.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Nodes.KeyedProcessor>> Processors { get; set; }

	/// <summary>
	/// <para>
	/// Total number of bytes of all documents produced by the pipeline.
	/// This field is only present on pipelines which are the first to process a document.
	/// Thus, it is not present on pipelines which only serve as a final pipeline after a default pipeline, a pipeline run after a reroute processor, or pipelines in pipeline processors.
	/// In situations where there are subsequent pipelines, the value represents the size of the document after all pipelines have run.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long ProducedAsFirstPipelineInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total time, in milliseconds, spent preprocessing ingest documents during the lifetime of this node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TimeInMillis { get; set; }
}