// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Nodes;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Nodes.Json.FileSystemTotalConverter))]
public sealed partial class FileSystemTotal
{
#if NET7_0_OR_GREATER
	public FileSystemTotal()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FileSystemTotal()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FileSystemTotal(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total disk space available to this Java virtual machine on all file stores.
	/// Depending on OS or process level restrictions, this might appear less than <c>free</c>.
	/// This is the actual amount of free disk space the Elasticsearch node can utilise.
	/// </para>
	/// </summary>
	public string? Available { get; set; }

	/// <summary>
	/// <para>
	/// Total number of bytes available to this Java virtual machine on all file stores.
	/// Depending on OS or process level restrictions, this might appear less than <c>free_in_bytes</c>.
	/// This is the actual amount of free disk space the Elasticsearch node can utilise.
	/// </para>
	/// </summary>
	public long? AvailableInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total unallocated disk space in all file stores.
	/// </para>
	/// </summary>
	public string? Free { get; set; }

	/// <summary>
	/// <para>
	/// Total number of unallocated bytes in all file stores.
	/// </para>
	/// </summary>
	public long? FreeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all file stores.
	/// </para>
	/// </summary>
	public string? Total { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all file stores in bytes.
	/// </para>
	/// </summary>
	public long? TotalInBytes { get; set; }
}